/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.translator;

import com.ibm.wala.automaton.grammar.string.ContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.DeepGrammarCopier;
import com.ibm.wala.automaton.grammar.string.DeepRuleCopier;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammarCopier;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.IRuleCopier;
import com.ibm.wala.automaton.grammar.string.IllegalGrammarException;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.regex.string.IPattern;
import com.ibm.wala.automaton.regex.string.IPatternCompiler;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.ILanguageSymbol;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.IValueSymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IntSymbol;
import com.ibm.wala.automaton.string.Minimization;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.automaton.string.VariableReplacer;
import com.ibm.wala.samso.m2lstr.DeclarationSets;
import com.ibm.wala.samso.m2lstr.IExtendedFormulaFactory;
import com.ibm.wala.samso.m2lstr.M2LSymbol;
import com.ibm.wala.samso.m2lstr.RegexpToM2L;
import com.ibm.wala.samso.translator.IConstraintEncoder;
import com.ibm.wala.samso.translator.IDeclarationSet;
import com.ibm.wala.samso.translator.SSAConstantRemover;
import com.ibm.wala.samso.translator.SolverContext;
import com.ibm.wala.samso.translator.repository.IFormulaTemplate;
import com.ibm.wala.samso.translator.repository.IM2LTranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.ISolverCache;
import com.ibm.wala.stringAnalysis.translator.ISolverStack;
import com.ibm.wala.stringAnalysis.translator.ITranslator;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.SimpleConstraintSolver;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.MonitorUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class M2LConstraintEncoder
extends SimpleConstraintSolver<IDeclarationSet>
implements IConstraintEncoder {
    private final IExtendedFormulaFactory ffactory;
    private final IPatternCompiler<IDeclarationSet> patternCompiler;
    private final IGrammarCopier constRemover = new DeepGrammarCopier((IRuleCopier)new DeepRuleCopier((ISymbolCopier)new SSAConstantRemover((ISymbol)new StringSymbol(""))));
    private final Stack<SolverContext> context;
    private final SolverContext initialContext;

    public M2LConstraintEncoder(IM2LTranslatorRepository repository, ISolverCache<IDeclarationSet> cache, ISolverStack stack, SolverContext initialContext, MonitorUtil.IProgressMonitor monitor) {
        super((ITranslatorRepository)repository, cache, stack, monitor);
        this.ffactory = repository.getFormulaFactory();
        this.patternCompiler = new RegexpToM2L(this.ffactory);
        this.context = new Stack();
        this.initialContext = initialContext;
        this.pushContext(initialContext);
    }

    protected void init() {
        super.init();
        this.context.clear();
        this.pushContext(this.initialContext);
    }

    @Override
    public IExtendedFormulaFactory getFormulaFactory() {
        return this.ffactory;
    }

    @Override
    public void pushContext(SolverContext ctx) {
        this.context.add(ctx);
        SAUtil.println((Object)("push context: " + (Object)((Object)ctx)));
        SAUtil.println((Object)("current context: " + this.context));
    }

    @Override
    public void popContext() {
        this.context.pop();
        SAUtil.println((Object)"pop context");
        SAUtil.println((Object)("current context: " + this.context));
    }

    public SolverContext getCurrentContext() {
        return this.context.peek();
    }

    @Override
    public IPatternCompiler<IDeclarationSet> getRegexCompiler() {
        return this.patternCompiler;
    }

    protected IDeclarationSet approximate(IDeclarationSet r, int i) {
        return r;
    }

    protected IDeclarationSet composeResult(SimpleGrammar g) {
        ContextFreeGrammar cfg = new ContextFreeGrammar(g);
        if (this.getCurrentContext().equals((Object)SolverContext.POSITION)) {
            try {
                Set isyms = Grammars.constantValues((IGrammar)cfg, (IVariable)cfg.getStartSymbol(), IntSymbol.class);
                HashSet<IDeclarationSet> declSets = new HashSet<IDeclarationSet>();
                for (IntSymbol isym : isyms) {
                    IDeclarationSet declSet = DeclarationSets.createDeclarationSetForPosition(isym.intValue(), this.ffactory);
                    declSets.add(declSet);
                }
                return DeclarationSets.createUnionForPosition(declSets, this.ffactory);
            }
            catch (IllegalGrammarException e) {
                return DeclarationSets.createAnyForPosition(this.ffactory);
            }
        }
        cfg = (IContextFreeGrammar)cfg.copy(this.constRemover);
        Set strs = Grammars.stringValues((IContextFreeGrammar)cfg, (int)5);
        if (this.getCurrentContext().equals((Object)SolverContext.REGEXP)) {
            if (strs == null) {
                return DeclarationSets.createAny(this.ffactory);
            }
            if (strs.isEmpty()) {
                return this.createEmpty();
            }
            HashSet<IDeclarationSet> declSets = new HashSet<IDeclarationSet>();
            for (String str : strs) {
                declSets.add(DeclarationSets.createDeclarationSetForRegexp(str, this.ffactory));
            }
            return DeclarationSets.createUnion(declSets, this.ffactory);
        }
        if (strs == null) {
            IAutomaton fsa = Grammars.toAutomaton((IContextFreeGrammar)cfg);
            IAutomaton minFsa = Minimization.minimize((IAutomaton)fsa, (int)Integer.MAX_VALUE);
            IPattern pat = Automatons.toRegex((IAutomaton)minFsa);
            return (IDeclarationSet)this.patternCompiler.compile(pat);
        }
        if (strs.isEmpty()) {
            return this.createEmpty();
        }
        HashSet<IDeclarationSet> declSets = new HashSet<IDeclarationSet>();
        for (String str : strs) {
            declSets.add(DeclarationSets.createDeclarationSet(str, this.ffactory));
        }
        return DeclarationSets.createUnion(declSets, this.ffactory);
    }

    protected IDeclarationSet composeResult(IValueSymbol val) {
        if (this.getCurrentContext().equals((Object)SolverContext.POSITION)) {
            if (val instanceof IntSymbol) {
                IntSymbol ival = (IntSymbol)val;
                return DeclarationSets.createDeclarationSetForPosition(ival.intValue(), this.ffactory);
            }
            return DeclarationSets.createAnyForPosition(this.ffactory);
        }
        if (this.getCurrentContext().equals((Object)SolverContext.REGEXP)) {
            StringSymbol s = val.stringSymbolValue();
            return DeclarationSets.createDeclarationSetForRegexp(s.getName(), this.ffactory);
        }
        if (val instanceof IntSymbol) {
            IntSymbol ival = (IntSymbol)val;
            return DeclarationSets.createDeclarationSet(Character.toString(ival.charValue()), this.ffactory);
        }
        StringSymbol s = val.stringSymbolValue();
        return DeclarationSets.createDeclarationSet(s.getName(), this.ffactory);
    }

    protected IDeclarationSet composeResult(ILanguageSymbol<?> val) {
        IDeclarationSet declSet = (IDeclarationSet)val.getLanguage();
        return declSet;
    }

    protected IDeclarationSet composeResults(Collection<IDeclarationSet> c) {
        if (this.getCurrentContext().equals((Object)SolverContext.POSITION)) {
            return DeclarationSets.createUnionForPosition(c, this.ffactory);
        }
        return DeclarationSets.createUnion(c, this.ffactory);
    }

    protected IDeclarationSet concatResults(List<IDeclarationSet> l) {
        if (l.size() == 1) {
            return l.iterator().next();
        }
        if (this.getCurrentContext().equals((Object)SolverContext.POSITION)) {
            return DeclarationSets.createAnyForPosition(this.ffactory);
        }
        return DeclarationSets.createConcatenation(l, this.ffactory);
    }

    protected boolean contains(IDeclarationSet r1, IDeclarationSet r2) {
        return r1.containsAll(r2);
    }

    protected IDeclarationSet createAny() {
        if (this.getCurrentContext().equals((Object)SolverContext.POSITION)) {
            return DeclarationSets.createAnyForPosition(this.ffactory);
        }
        return DeclarationSets.createAny(this.ffactory);
    }

    protected IDeclarationSet createEmpty() {
        if (this.getCurrentContext().equals((Object)SolverContext.POSITION)) {
            return DeclarationSets.createAnyForPosition(this.ffactory);
        }
        return DeclarationSets.createEmpty(this.ffactory);
    }

    protected SimpleGrammar composeGrammar(IDeclarationSet r) {
        IVariable v = this.varFactory.createVariable(Grammars.variablePrefix);
        return new SimpleGrammar(v, new IProductionRule[]{new ProductionRule(v, (ISymbol)new M2LSymbol(r))});
    }

    protected IDeclarationSet minimize(IDeclarationSet g) {
        return g;
    }

    protected IDeclarationSet substitute(IDeclarationSet g) {
        return g;
    }

    protected IDeclarationSet solveCyclic(IVariable v, IDeclarationSet nonCyclic, SimpleGrammar cyclic, int cycle) {
        if (this.getCurrentContext().equals((Object)SolverContext.STRING)) {
            IDeclarationSet declSet = DeclarationSets.createAny(this.ffactory);
            M2LSymbol sym = new M2LSymbol(declSet);
            HashMap<IVariable, M2LSymbol> m = new HashMap<IVariable, M2LSymbol>();
            m.put(v, sym);
            SimpleGrammar sg = (SimpleGrammar)cyclic.copy((IGrammarCopier)new DeepGrammarCopier((IRuleCopier)new DeepRuleCopier((ISymbolCopier)new VariableReplacer(m)){

                public IVariable copyLeft(IVariable v) {
                    return v;
                }
            }){

                public IVariable copyStartSymbol(IVariable s) {
                    return s;
                }
            });
            return DeclarationSets.createAnyForPosition(this.ffactory);
        }
        return this.createAny();
    }

    protected IDeclarationSet translateGrammar(ITranslator<IDeclarationSet> translator, String funcName, ISymbol recv, List<ISymbol> params, IProductionRule invokeRule, SimpleGrammar targetGrammar, int cycle) {
        IFormulaTemplate t = (IFormulaTemplate)translator;
        int target = translator.getTarget();
        target = target == -1 ? 0 : ++target;
        SolverContext ctx = this.getCurrentContext();
        if (t.isIndexFunction(ctx)) {
            if (!ctx.equals((Object)SolverContext.POSITION)) {
                return DeclarationSets.createAny(this.ffactory);
            }
        } else if (t.isRegexpFunction(ctx)) {
            if (!ctx.equals((Object)SolverContext.REGEXP)) {
                return DeclarationSets.createAny(this.ffactory);
            }
        } else if (!ctx.equals((Object)SolverContext.STRING)) {
            return DeclarationSets.createAnyForPosition(this.ffactory);
        }
        if (t.isIndexParameter(target, ctx)) {
            this.pushContext(SolverContext.POSITION);
        } else if (t.isRegexpParameter(target, ctx)) {
            this.pushContext(SolverContext.REGEXP);
        } else {
            this.pushContext(SolverContext.STRING);
        }
        IDeclarationSet result = (IDeclarationSet)super.translateGrammar(translator, funcName, recv, params, invokeRule, targetGrammar, cycle);
        this.popContext();
        return result;
    }
}

