/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.cli.config;

import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.config.Messages;
import com.ibm.appscan.cli.config.components.ScanManager;
import com.ibm.appscan.cli.config.handlers.CreateHandler;
import com.ibm.appscan.cli.config.handlers.ScanTargetHandler;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.CustomTargetInfo;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.model.xml.IModelXMLConstants;
import com.ibm.appscan.common.utils.ClasspathUtil;
import com.ibm.appscan.common.utils.PathUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.common.xml.XMLFileReader;
import com.ibm.appscan.common.xml.XMLStreamReader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;

public class ConfigurationReader
extends XMLFileReader
implements IModelXMLConstants {
    private static final int INCLUDE = 0;
    private static final int EXCLUDE = 1;
    private String m_configLocation;
    private String m_parent_node;
    private IScan m_scan = ScanManager.getInstance().getActiveScan();
    private ScanTargetHandler m_scanTargetHandler = new ScanTargetHandler();
    private String m_saveLocation;
    private String m_currentTarget = null;
    private List<String> m_targetsWithTopLevelIncludes;
    private List<String> m_targetsWithTopLevelExcludes;

    public ConfigurationReader(File file, String name) {
        super(file);
        this.m_configLocation = file.getAbsoluteFile().getParentFile().getAbsolutePath();
        if (this.m_scan == null) {
            CreateHandler createHandler = new CreateHandler();
            this.m_scan = createHandler.createScan();
        }
        this.m_targetsWithTopLevelIncludes = new ArrayList<String>();
        this.m_targetsWithTopLevelExcludes = new ArrayList<String>();
    }

    private boolean processConfiguration(StartElement element) {
        if ("true".equalsIgnoreCase(this.getAttribute(element, "thirdParty"))) {
            System.setProperty("thirdParty", "");
        }
        if ("true".equalsIgnoreCase(this.getAttribute(element, "openSourceOnly"))) {
            System.setProperty("OPENSOURCE_ONLY", "");
        }
        if ("true".equalsIgnoreCase(this.getAttribute(element, "sourceCodeOnly"))) {
            SystemUtil.setSourceCodeOnly();
        }
        if ("true".equalsIgnoreCase(this.getAttribute(element, "staticAnalysisOnly"))) {
            SystemUtil.setStaticAnalysisOnly();
        }
        String disableSecrets = this.getAttribute(element, "disableSecrets");
        String enableSecrets = this.getAttribute(element, "enableSecrets");
        String noSecrets = this.getAttribute(element, "noSecrets");
        if (!("false".equalsIgnoreCase(disableSecrets) && "false".equalsIgnoreCase(enableSecrets) && "false".equalsIgnoreCase(noSecrets))) {
            if ("true".equalsIgnoreCase(disableSecrets) || "true".equalsIgnoreCase(noSecrets) || "false".equalsIgnoreCase(enableSecrets)) {
                SystemUtil.disableSecretsScanning();
            } else if ("true".equalsIgnoreCase(enableSecrets) || "false".equalsIgnoreCase(disableSecrets) || "false".equalsIgnoreCase(noSecrets)) {
                SystemUtil.enableSecretsScanning();
            }
        }
        if ("true".equalsIgnoreCase(this.getAttribute(element, "secretsOnly"))) {
            SystemUtil.setSecretsOnly();
        }
        if ("true".equalsIgnoreCase(this.getAttribute(element, "noConfigFiles"))) {
            SystemUtil.disableProcessingConfigFiles();
        }
        return true;
    }

    private void processTargets(StartElement element) {
        this.m_parent_node = "Targets";
    }

    private void processTarget(StartElement element) {
        this.m_currentTarget = this.getAttribute(element, "path");
        if (this.m_currentTarget != null) {
            if (this.m_currentTarget.toLowerCase().endsWith(".git")) {
                URL gitURL = null;
                try {
                    gitURL = new URL(this.m_currentTarget);
                    boolean outputsOnly = Boolean.parseBoolean(this.getAttribute(element, "outputs-only"));
                    this.m_scanTargetHandler.addScanTarget(gitURL, outputsOnly);
                }
                catch (MalformedURLException e) {
                    CommonCLICore.getIOConsole().print(new Message(4, Messages.bind(Messages.INVALID_URL, this.m_currentTarget)));
                    CommonCLICore.getLogManager().log((Exception)e);
                }
            } else {
                String path = PathUtil.makeAbsolute((String)this.m_currentTarget, (String)this.m_configLocation);
                File target = new File(path);
                if (target.exists()) {
                    path = target.toURI().normalize().getPath();
                    path = SystemUtil.isWindows() ? path.substring(1) : path.substring(0);
                    this.m_currentTarget = path.replace("/", File.separator);
                    if (this.m_currentTarget.endsWith("/") || this.m_currentTarget.endsWith("\\")) {
                        this.m_currentTarget = this.m_currentTarget.substring(0, this.m_currentTarget.length() - 1);
                    }
                    if (this.m_parent_node.equals("Targets")) {
                        boolean outputsOnly = Boolean.parseBoolean(this.getAttribute(element, "outputs-only"));
                        if (this.m_currentTarget != null) {
                            this.m_scanTargetHandler.addScanTarget(this.m_currentTarget, outputsOnly);
                        }
                    }
                } else {
                    Message message = new Message(2, Messages.bind(Messages.SCAN_TARGET_NOT_FOUND, this.m_currentTarget));
                    CommonCLICore.getIOConsole().println(message);
                    CommonCLICore.getLogManager().log(message);
                }
            }
        }
    }

    private void processSettings(StartElement element) {
    }

    private void processTargetSettings(StartElement element) {
        this.m_parent_node = "TargetSettings";
    }

    private boolean processCustomTargetInfo(StartElement element) {
        Iterator<Attribute> iter = element.getAttributes();
        while (iter.hasNext()) {
            Attribute attribute = iter.next();
            CustomTargetInfo info = this.m_scan.getCustomTargetInfo(this.m_currentTarget);
            String key = attribute.getName().getLocalPart();
            String val = attribute.getValue();
            if (val == null || val.isEmpty()) continue;
            if (key.equals("additional_classpath") || key.equals("classpath")) {
                val = ClasspathUtil.joinRelativePaths((String)this.m_configLocation, (String[])new String[]{val});
                this.processClasspath(key, val);
            }
            if (key.equals("irx_minor_cache_home")) {
                System.setProperty("IRX_MINOR_CACHE_HOME", this.getAttribute(element, "irx_minor_cache_home"));
            }
            info.getBuildInfos().put(key, val);
        }
        return true;
    }

    private void processFilter(StartElement element, XMLStreamReader.ElementValue value, int filter) throws XMLStreamException {
        CustomTargetInfo info = this.m_scan.getCustomTargetInfo(this.m_currentTarget);
        if (this.m_parent_node.equals("TargetSettings")) {
            if (filter == 0) {
                if (this.m_targetsWithTopLevelIncludes.contains(this.m_currentTarget)) {
                    info.getIncludes().clear();
                    this.m_targetsWithTopLevelIncludes.remove(this.m_currentTarget);
                }
            } else if (filter == 1 && this.m_targetsWithTopLevelExcludes.contains(this.m_currentTarget)) {
                info.getExcludes().clear();
                this.m_targetsWithTopLevelExcludes.remove(this.m_currentTarget);
            }
        }
        if (filter == 0) {
            info.getIncludes().add(new StringPattern(value.getText()));
            if (this.m_parent_node.equals("Targets") && !this.m_targetsWithTopLevelIncludes.contains(this.m_currentTarget)) {
                this.m_targetsWithTopLevelIncludes.add(this.m_currentTarget);
            }
        } else if (filter == 1) {
            info.getExcludes().add(new StringPattern(value.getText()));
            if (this.m_parent_node.equals("Targets") && !this.m_targetsWithTopLevelExcludes.contains(this.m_currentTarget)) {
                this.m_targetsWithTopLevelExcludes.add(this.m_currentTarget);
            }
        }
    }

    protected boolean process(StartElement element, XMLStreamReader.ElementValue value) throws XMLStreamException {
        String name = element.getName().getLocalPart();
        if ("Configuration".equals(name)) {
            return this.processConfiguration(element);
        }
        if ("Targets".equals(name)) {
            this.processTargets(element);
        } else if ("Target".equals(name)) {
            this.processTarget(element);
        } else if ("Settings".equals(name)) {
            this.processSettings(element);
        } else if ("TargetSettings".equals(name)) {
            this.processTargetSettings(element);
        } else if ("CustomBuildInfo".equals(name)) {
            this.processCustomTargetInfo(element);
        } else if ("BuildInfo".equals(name)) {
            this.processCustomTargetInfo(element);
        }
        if ("Include".equals(name)) {
            this.processFilter(element, value, 0);
        }
        if ("Exclude".equals(name)) {
            this.processFilter(element, value, 1);
        }
        return true;
    }

    protected boolean process(EndElement element) {
        String name = element.getName().getLocalPart();
        if ("Targets".equals(name) || "TargetSettings".equals(name)) {
            this.m_parent_node = null;
        }
        return true;
    }

    public String getSaveLocation() {
        return this.m_saveLocation;
    }

    public ScanTargetHandler getScanTargetHandler() {
        return this.m_scanTargetHandler;
    }

    private void processClasspath(String key, String val) {
        File currentTarget = new File(this.m_currentTarget);
        if (currentTarget.isFile() && currentTarget.getParent() != null) {
            CustomTargetInfo parentInfo = this.m_scan.getCustomTargetInfo(currentTarget.getParent());
            if (parentInfo.getBuildInfos().containsKey(key)) {
                String existingVal = (String)parentInfo.getBuildInfos().get(key);
                parentInfo.getBuildInfos().put(key, existingVal + File.pathSeparator + val);
            } else {
                parentInfo.getBuildInfos().put(key, val);
            }
        }
    }
}

