/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.tomcat.compilers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TomcatUtil {
    private static final String BIN_PATH = "bin/";

    public static File findTomcatHome(File tomcatBase) {
        File homeDir;
        String env;
        if (new File(tomcatBase, "lib/catalina.jar").isFile()) {
            return tomcatBase;
        }
        if (new File(tomcatBase, "catalina.jar").isFile()) {
            return tomcatBase;
        }
        if (new File(tomcatBase, "conf/server.xml").isFile() && (env = System.getenv("CATALINA_HOME")) != null && (homeDir = new File(env)).isDirectory()) {
            return homeDir;
        }
        return null;
    }

    private static File findJar(File tomcatBase, File tomcatHome, String jarName) {
        File binPath = new File(tomcatBase, BIN_PATH);
        File jar = new File(binPath, jarName);
        if (!(jar.isFile() || (jar = new File(binPath = new File(tomcatHome, BIN_PATH), jarName)).isFile() || (jar = new File(tomcatBase, jarName)).isFile())) {
            jar = new File(tomcatHome, jarName);
        }
        return jar;
    }

    private static void addJarIFExistsToList(File tomcatBase, File tomcatHome, String jarName, List<String> entries) {
        File classpathJar = TomcatUtil.findJar(tomcatBase, tomcatHome, jarName);
        if (classpathJar.isFile()) {
            entries.add(classpathJar.getPath());
        }
    }

    private static void addLibs(List<String> entries, String path) {
        entries.add(path + "/lib");
        entries.add(path + "/lib/*");
        entries.add(path + "/*");
    }

    public static String[] computeClasspathEntries(File tomcatBase, File tomcatHome) {
        ArrayList<String> entries = new ArrayList<String>();
        String home = tomcatHome.getPath();
        TomcatUtil.addJarIFExistsToList(tomcatBase, tomcatHome, "bootstrap.jar", entries);
        TomcatUtil.addJarIFExistsToList(tomcatBase, tomcatHome, "tomcat-juli.jar", entries);
        TomcatUtil.addJarIFExistsToList(tomcatBase, tomcatHome, "commons-daemon.jar", entries);
        TomcatUtil.addLibs(entries, tomcatBase.getPath());
        if (!tomcatBase.equals(tomcatHome)) {
            TomcatUtil.addLibs(entries, home);
        }
        return entries.toArray(new String[entries.size()]);
    }
}

