/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.discovery.containers.docker;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.utils.ProcessRunner;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DockerRunner {
    private ProcessRunner.StreamHandler m_streamHandler;

    public DockerRunner() {
        this(SystemUtil.isDebug());
    }

    public DockerRunner(boolean showOutput) {
        this.setStreamHandler(showOutput);
    }

    public int run(List<String> arguments) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        if (SystemUtil.isWindows()) {
            args.add("cmd");
            args.add("/c");
        } else {
            args.add("/bin/sh");
            args.add("-c");
        }
        StringBuffer cmd = new StringBuffer();
        cmd.append("docker");
        for (String str : arguments) {
            cmd.append(" ").append(str);
        }
        args.add(cmd.toString());
        ProcessRunner runner = new ProcessRunner(args);
        return runner.run(this.m_streamHandler);
    }

    private void setStreamHandler(boolean showOutput) {
        this.m_streamHandler = showOutput ? new ProcessRunner.StreamHandler(){

            protected boolean handle(BufferedReader reader) throws IOException {
                String line;
                while ((line = reader.readLine()) != null) {
                    CommonCore.getIOConsole().println(line);
                }
                return super.handle(reader);
            }
        } : new ProcessRunner.StreamHandler();
    }
}

