/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.discovery.containers.utils;

import com.hcl.appscan.discovery.containers.docker.DockerRunner;
import com.hcl.appscan.discovery.containers.utils.TarUtils;
import com.ibm.appscan.common.CommonCore;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContainerUtils {
    public static boolean isValidContainerName(String name) {
        Pattern pattern = Pattern.compile("[A-Za-z0-9_\\.\\-]+");
        Matcher matcher = pattern.matcher(name);
        return matcher.matches();
    }

    public static boolean isValidImageName(String name) {
        Pattern pattern = Pattern.compile("[A-Za-z0-9:/_\\.\\-]+");
        Matcher matcher = pattern.matcher(name);
        return matcher.matches();
    }

    public static boolean isImageArchive(File image) {
        boolean ret = false;
        try {
            ArrayList<String> files = new ArrayList<String>();
            files.add("repositories");
            files.add("manifest.json");
            ret = TarUtils.containsFiles(image, files);
        }
        catch (IOException e) {
            CommonCore.getLogManager().log((Exception)e);
        }
        return ret;
    }

    public static boolean isContainerArchive(File image) {
        boolean ret = false;
        try {
            ret = TarUtils.containsFile(image, ".dockerenv");
        }
        catch (IOException e) {
            CommonCore.getLogManager().log((Exception)e);
        }
        return ret;
    }

    public static boolean isDockerInstalled() {
        int ret = 1;
        ArrayList<String> args = new ArrayList<String>();
        args.add("version");
        try {
            ret = new DockerRunner().run(args);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret == 0;
    }
}

