/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.internal.discovery.containers.docker;

import com.hcl.appscan.discovery.containers.IContainerEngine;
import com.hcl.appscan.discovery.containers.Messages;
import com.hcl.appscan.discovery.containers.docker.DockerEngine;
import com.hcl.appscan.discovery.containers.docker.IDockerHandler;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import java.io.File;
import java.io.IOException;

public class ContainerHandler
implements IDockerHandler {
    private String m_containerName;
    private IProgress m_progress;
    private IContainerEngine m_engine;
    private boolean m_createdArchive = false;

    public ContainerHandler(String containerName, IProgress progress) {
        this(containerName, progress, new DockerEngine());
    }

    public ContainerHandler(String container, IProgress progress, IContainerEngine engine) {
        this.m_containerName = container;
        this.m_progress = progress;
        this.m_engine = engine;
    }

    @Override
    public File getContainerArchive() throws AppScanException {
        File archive = this.getArchive();
        try {
            this.m_progress.setStatus(new Message(1, Messages.DOCKER_EXPORT));
            this.m_engine.exportContainer(archive, this.m_containerName);
            this.m_createdArchive = true;
        }
        catch (AppScanException | IOException e) {
            this.handleException(this.m_progress, e, Messages.bind(Messages.ERROR_EXPORT_CONTAINER, this.m_containerName, e.getMessage()));
        }
        finally {
            if (this.m_createdArchive) {
                archive.deleteOnExit();
            }
        }
        return archive;
    }

    private File getArchive() {
        File archive = new File(CommonCore.getDirectoryLocator().getTemp(), "container.tar");
        archive.getParentFile().mkdirs();
        if (archive.isFile()) {
            archive.delete();
        }
        return archive;
    }
}

