/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.thirdpartylib.dependency.golang;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.discovery.thirdpartylib.Messages;
import com.ibm.appscan.discovery.thirdpartylib.dependency.golang.GoDependency;
import com.ibm.appscan.discovery.thirdpartylib.dependency.golang.GoDependencyCollector;
import com.ibm.appscan.discovery.thirdpartylib.dependency.golang.IGoConstants;
import com.ibm.appscan.discovery.thirdpartylib.utils.ProcessUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.json.JSON;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class GoDependencyProcessor {
    private static final String BACKUP_NAME = "go.mod";
    private static Map<String, List<String>> m_processed = new HashMap<String, List<String>>();
    private File m_dependenciesFile;
    private File m_saveLocation;
    private ILogManager m_log;

    public GoDependencyProcessor(File dependenciesFile, File saveLocation, ILogManager logManager) {
        this.m_dependenciesFile = dependenciesFile;
        this.m_saveLocation = saveLocation;
        this.m_log = logManager;
    }

    public Map<File, String> processDependencies() {
        HashMap<File, String> files = new HashMap<File, String>();
        try {
            JSONArray data = this.getJsonData();
            for (int i = 0; i < data.length(); ++i) {
                JSONObject obj = data.getJSONObject(i);
                String version = this.getVersionToProcess(obj);
                if (version == null) continue;
                obj.put("Version", (Object)version);
                files.putAll(this.processDependency(obj));
            }
        }
        catch (IOException | JSONException e) {
            this.m_log.log(new Message(4, Messages.getMessage("processing.dependencies.error", this.m_dependenciesFile, e.getMessage())));
        }
        return files;
    }

    public static void clearProcessedPackages() {
        m_processed.clear();
    }

    private Map<File, String> processDependency(JSONObject obj) throws JSONException, IOException {
        HashMap<File, String> files = new HashMap<File, String>();
        File modFile = new File(obj.getString("GoMod"));
        if (!modFile.isFile()) {
            return files;
        }
        String path = obj.getString("Path");
        String version = obj.getString("Version");
        String outputPath = path.replaceAll("/", "_") + "_" + version + ".json";
        File outputFile = new File(this.m_saveLocation, outputPath);
        this.logAndPrintMessage(new Message(1, Messages.getMessage("processing.package", path, version)));
        if (!m_processed.containsKey(path)) {
            m_processed.put(path, new ArrayList());
        }
        m_processed.get(path).add(version);
        if (this.runListCommand(modFile, outputFile) == 0) {
            files.put(outputFile, outputFile.getName());
            GoDependencyProcessor processor = new GoDependencyProcessor(outputFile, this.m_saveLocation, this.m_log);
            files.putAll(processor.processDependencies());
        } else {
            this.m_log.log(new Message(4, Messages.getMessage("processing.failed", path)));
            if (outputFile.isFile()) {
                this.m_log.log(new Message(4, IOUtil.readFileIntoString((File)outputFile)));
            }
        }
        return files;
    }

    private JSONArray getJsonData() throws IOException {
        try {
            String contents = "[\n" + IOUtil.readFileIntoString((File)this.m_dependenciesFile) + "]";
            contents = contents.replaceAll("}[^,]", "},");
            return (JSONArray)JSON.parse((String)contents);
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runListCommand(File modFile, File outputFile) throws IOException {
        File goMod = new File(modFile.getParentFile(), BACKUP_NAME);
        int success = 0;
        try {
            Files.copy(modFile.toPath(), goMod.toPath(), StandardCopyOption.REPLACE_EXISTING);
            success = ProcessUtils.run("Go".toLowerCase(), Arrays.asList(IGoConstants.GO_LIST), modFile.getParentFile(), outputFile, null);
        }
        finally {
            goMod.delete();
        }
        return success;
    }

    private String getVersionToProcess(JSONObject obj) throws JSONException {
        if (this.isNullOrFalse("Main", obj) && this.isNullOrFalse("Indirect", obj)) {
            String path = obj.getString("Path").trim();
            String version = obj.getString("Version").trim();
            if (GoDependencyCollector.getDownloadedPackages().containsKey(path)) {
                GoDependency dependency = GoDependencyCollector.getDownloadedPackages().get(path);
                if (dependency.hasVersion(version)) {
                    return this.haveProcessed(path, version) ? null : version;
                }
                String latestVersion = dependency.getLatestVersion();
                return this.haveProcessed(path, latestVersion) ? null : latestVersion;
            }
        }
        return null;
    }

    private boolean haveProcessed(String path, String version) {
        return m_processed.containsKey(path) && m_processed.get(path).contains(version);
    }

    private boolean isNullOrFalse(String key, JSONObject obj) throws JSONException {
        return !obj.has(key) || !obj.getBoolean(key);
    }

    private void logAndPrintMessage(Message message) {
        CommonCore.getIOConsole().println(message);
        this.m_log.log(message);
    }
}

