/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.html;

import com.ibm.wala.cast.ir.translator.TranslatorToCAst;
import com.ibm.wala.cast.js.html.DefaultSourceExtractor;
import com.ibm.wala.cast.js.html.EmptyFileMapping;
import com.ibm.wala.cast.js.html.FileMapping;
import com.ibm.wala.cast.js.html.IHtmlCallback;
import com.ibm.wala.cast.js.html.IHtmlParser;
import com.ibm.wala.cast.js.html.ITag;
import com.ibm.wala.cast.js.html.IUrlResolver;
import com.ibm.wala.cast.js.html.IdentityUrlResolver;
import com.ibm.wala.cast.js.html.JSSourceExtractor;
import com.ibm.wala.cast.js.html.MappedSourceFileModule;
import com.ibm.wala.cast.js.html.MappedSourceModule;
import com.ibm.wala.cast.js.html.SourceRegion;
import com.ibm.wala.cast.js.html.WebUtil;
import com.ibm.wala.cast.js.html.jericho.JerichoHtmlParser;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.functions.Function;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;

public class DomLessSourceExtractor
extends JSSourceExtractor {
    private static final Pattern LEGAL_JS_IDENTIFIER_REGEXP = Pattern.compile("^[a-zA-Z$_][a-zA-Z\\d$_]*$");
    private static final Pattern LEGAL_JS_KEYWORD_REGEXP = Pattern.compile("^((break)|(case)|(catch)|(continue)|(debugger)|(default)|(delete)|(do)|(else)|(finally)|(for)|(function)|(if)|(in)|(instanceof)|(new)|(return)|(switch)|(this)|(throw)|(try)|(typeof)|(var)|(void)|(while)|(with))$");
    public static Function<Void, JSSourceExtractor> factory = new Function<Void, JSSourceExtractor>(){

        public JSSourceExtractor apply(Void object) {
            return new DomLessSourceExtractor();
        }
    };
    private File tempFile;

    @Override
    public Set<MappedSourceModule> extractSources(URL entrypointUrl, IHtmlParser htmlParser, IUrlResolver urlResolver) throws IOException, TranslatorToCAst.Error {
        File outputFile;
        Reader inputStreamReader = WebUtil.getStream(entrypointUrl);
        IGeneratorCallback htmlCallback = this.createHtmlCallback(entrypointUrl, urlResolver);
        htmlParser.parse(entrypointUrl, inputStreamReader, htmlCallback, entrypointUrl.getFile());
        SourceRegion finalRegion = new SourceRegion();
        htmlCallback.writeToFinalRegion(finalRegion);
        this.tempFile = outputFile = this.createOutputFile(entrypointUrl, DELETE_UPON_EXIT, USE_TEMP_NAME);
        FileMapping fileMapping = finalRegion.writeToFile(new PrintWriter(new FileWriter(outputFile)));
        if (fileMapping == null) {
            fileMapping = new EmptyFileMapping();
        }
        MappedSourceFileModule singleFileModule = new MappedSourceFileModule(outputFile, outputFile.getName(), fileMapping);
        return Collections.singleton(singleFileModule);
    }

    protected IGeneratorCallback createHtmlCallback(URL entrypointUrl, IUrlResolver urlResolver) {
        return new HtmlCallback(entrypointUrl, urlResolver);
    }

    private File createOutputFile(URL url, boolean delete, boolean useTempName) throws IOException {
        File outputFile;
        String fileName = new File(url.getFile()).getName();
        if (fileName.length() < 5) {
            fileName = "xxxx" + fileName;
        }
        if ((outputFile = useTempName ? File.createTempFile(fileName, ".js") : new File(fileName)).exists()) {
            outputFile.delete();
        }
        if (delete) {
            outputFile.deleteOnExit();
        }
        return outputFile;
    }

    public static void main(String[] args) throws IOException, TranslatorToCAst.Error {
        DefaultSourceExtractor domLessScopeGenerator = new DefaultSourceExtractor();
        JSSourceExtractor.DELETE_UPON_EXIT = false;
        URL entrypointUrl = new URL(args[0]);
        JerichoHtmlParser htmlParser = new JerichoHtmlParser();
        IdentityUrlResolver urlResolver = new IdentityUrlResolver();
        Set<MappedSourceModule> res = ((JSSourceExtractor)domLessScopeGenerator).extractSources(entrypointUrl, htmlParser, urlResolver);
        MappedSourceModule entry = res.iterator().next();
        System.out.println(entry);
        System.out.println(entry.getMapping());
    }

    @Override
    public File getTempFile() {
        return this.tempFile;
    }

    protected static class HtmlCallback
    implements IGeneratorCallback {
        public static final boolean DEBUG = false;
        protected final URL entrypointUrl;
        protected final IUrlResolver urlResolver;
        protected final SourceRegion scriptRegion;
        protected final SourceRegion domRegion;
        protected final SourceRegion entrypointRegion;
        private ITag currentScriptTag;
        private ITag currentCommentTag;
        private int nodeCounter = 0;
        private int scriptNodeCounter = 0;

        public HtmlCallback(URL entrypointUrl, IUrlResolver urlResolver) {
            this.entrypointUrl = entrypointUrl;
            this.urlResolver = urlResolver;
            this.scriptRegion = new SourceRegion();
            this.domRegion = new SourceRegion();
            this.entrypointRegion = new SourceRegion();
            this.addDefaultHandlerInvocations();
        }

        protected void writeEntrypoint(String ep) {
            this.entrypointRegion.println(ep);
        }

        protected void addDefaultHandlerInvocations() {
            this.writeEntrypoint("window.onload();");
        }

        protected CAstSourcePositionMap.Position makePos(int lineNumber, ITag governingTag) {
            return this.makePos(this.entrypointUrl, lineNumber, governingTag);
        }

        protected CAstSourcePositionMap.Position makePos(URL url, int lineNumber, ITag governingTag) {
            return governingTag.getElementPosition();
        }

        @Override
        public void handleEndTag(ITag tag) {
            if (tag.getName().equalsIgnoreCase("script")) {
                assert (this.currentScriptTag != null);
                this.currentScriptTag = null;
            } else if (this.currentScriptTag != null && tag.getName().equals("!--")) {
                assert (this.currentCommentTag != null);
                this.currentCommentTag = null;
            }
        }

        @Override
        public void handleText(CAstSourcePositionMap.Position p, String text) {
            if (this.currentScriptTag != null && this.currentCommentTag == null) {
                if (text.startsWith("<![CDATA[")) {
                    assert (text.endsWith("]]>"));
                    text = text.substring(9, text.length() - 11);
                }
                URL url = this.entrypointUrl;
                try {
                    url = new URL(this.entrypointUrl, "#" + this.scriptNodeCounter);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                this.scriptRegion.println(text, this.currentScriptTag.getContentPosition(), url, true);
            }
        }

        @Override
        public void handleStartTag(ITag tag) {
            if (tag.getName().equalsIgnoreCase("script")) {
                this.handleScript(tag);
                assert (this.currentScriptTag == null);
                this.currentScriptTag = tag;
                ++this.scriptNodeCounter;
            } else if (this.currentScriptTag != null && tag.getName().equals("!--")) {
                this.currentCommentTag = tag;
            }
            this.handleDOM(tag);
        }

        private boolean isUsableIdentifier(String x) {
            return x != null && LEGAL_JS_IDENTIFIER_REGEXP.matcher(x).matches() && !LEGAL_JS_KEYWORD_REGEXP.matcher(x).matches();
        }

        protected void handleDOM(ITag tag) {
            String funcName = "node" + this.nodeCounter++;
            this.handleDOM(tag, funcName);
        }

        protected void handleDOM(ITag tag, String funcName) {
            Map<String, Pair<String, CAstSourcePositionMap.Position>> attributeSet = tag.getAllAttributes();
            for (Map.Entry<String, Pair<String, CAstSourcePositionMap.Position>> a : attributeSet.entrySet()) {
                this.handleAttribute(a, funcName, tag);
            }
        }

        private void handleAttribute(Map.Entry<String, Pair<String, CAstSourcePositionMap.Position>> a, String funcName, ITag tag) {
            URL url = this.entrypointUrl;
            try {
                url = new URL(this.entrypointUrl, "#" + tag.getElementPosition().getFirstOffset());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            CAstSourcePositionMap.Position pos = (CAstSourcePositionMap.Position)a.getValue().snd;
            String attName = a.getKey();
            String attValue = (String)a.getValue().fst;
            if (attName.toLowerCase().startsWith("on") || attValue != null && attValue.toLowerCase().startsWith("javascript:")) {
                String fName = tag.getName().toLowerCase() + "_" + attName + "_" + funcName;
                String signatureLine = "function " + fName + "(event) {";
                this.domRegion.println(signatureLine + "\n" + this.extructJS(attValue) + "\n}", pos, url, true);
                this.writeEntrypoint("\t" + fName + "(null);", pos, url, true);
            }
        }

        protected void writeEntrypoint(String text, CAstSourcePositionMap.Position pos, URL url, boolean b) {
            this.entrypointRegion.println(text, pos, url, b);
        }

        protected static Pair<String, Character> quotify(String value) {
            char quote;
            if (value.indexOf(34) < 0) {
                quote = '\"';
            } else if (value.indexOf("'") < 0) {
                quote = '\"';
            } else {
                quote = '\"';
                value = value.replaceAll("\"", "\\\"");
            }
            if (value.indexOf(10) >= 0) {
                value = value.replaceAll("\n", "\\n");
            }
            return Pair.make((Object)value, (Object)Character.valueOf(quote));
        }

        private String extructJS(String attValue) {
            if (attValue == null) {
                return "";
            }
            String content = attValue.toLowerCase().equals("javascript:") ? attValue.substring("javascript:".length()) : attValue;
            return content;
        }

        protected void handleScript(ITag tag) {
            Pair<String, CAstSourcePositionMap.Position> content = tag.getAttributeByName("src");
            try {
                if (content != null) {
                    this.getScriptFromUrl((String)content.fst, tag);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getScriptFromUrl(String urlAsString, ITag scriptTag) throws IOException, MalformedURLException {
            InputStreamReader scriptInputStream;
            URL scriptSrc = new URL(this.entrypointUrl, urlAsString);
            try {
                BOMInputStream bs = new BOMInputStream(scriptSrc.openConnection().getInputStream(), false, new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_32LE, ByteOrderMark.UTF_32BE});
                if (bs.hasBOM()) {
                    System.err.println("removing BOM " + bs.getBOM());
                }
                scriptInputStream = new InputStreamReader((InputStream)bs);
            }
            catch (Exception e) {
                return;
            }
            try (BufferedReader scriptReader = null;){
                String line;
                scriptReader = new BufferedReader(scriptInputStream);
                StringBuffer x = new StringBuffer();
                while ((line = scriptReader.readLine()) != null) {
                    x.append(line).append("\n");
                }
                this.scriptRegion.println(x.toString(), scriptTag.getElementPosition(), scriptSrc, false);
            }
        }

        protected String getScriptName(URL url) throws MalformedURLException {
            String file = url.getFile();
            int lastIdxOfSlash = file.lastIndexOf(47);
            file = lastIdxOfSlash == -1 ? file : file.substring(lastIdxOfSlash + 1);
            return file;
        }

        protected void writeEventLoopHeader(SourceRegion finalRegion) {
            finalRegion.println("while (true){  // event loop model");
        }

        @Override
        public void writeToFinalRegion(SourceRegion finalRegion) {
            finalRegion.println("window.__MAIN__ = function __WINDOW_MAIN__(){");
            finalRegion.write(this.scriptRegion);
            finalRegion.write(this.domRegion);
            finalRegion.println("  document.URL = new String(\"" + this.entrypointUrl + "\");");
            this.writeEventLoopHeader(finalRegion);
            finalRegion.write(this.entrypointRegion);
            finalRegion.println("} // event loop model");
            finalRegion.println("} // end of window.__MAIN__");
            finalRegion.println("window.__MAIN__();");
        }
    }

    protected static interface IGeneratorCallback
    extends IHtmlCallback {
        public void writeToFinalRegion(SourceRegion var1);
    }
}

