/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ipa.callgraph;

import com.ibm.wala.cast.js.ipa.summaries.JavaScriptSummarizedFunction;
import com.ibm.wala.cast.js.ipa.summaries.JavaScriptSummary;
import com.ibm.wala.cast.js.loader.JSCallSiteReference;
import com.ibm.wala.cast.js.loader.JavaScriptLoader;
import com.ibm.wala.cast.js.ssa.JSInstructionFactory;
import com.ibm.wala.cast.js.types.JavaScriptMethods;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.types.AstMethodReference;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.MethodTargetSelector;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.strings.Atom;
import java.util.Map;

public class JavaScriptFunctionDotCallTargetSelector
implements MethodTargetSelector {
    public static boolean WARN_ABOUT_IMPRECISE_CALLGRAPH = true;
    public static final boolean DEBUG_SYNTHETIC_CALL_METHODS = false;
    private static final TypeName CALL_TYPE_NAME = TypeName.findOrCreate((String)"Lprologue.js/Function_prototype_call");
    private final MethodTargetSelector base;
    private static final boolean SEPARATE_SYNTHETIC_METHOD_PER_SITE = false;
    private final Map<Object, JavaScriptSummarizedFunction> callModels = HashMapFactory.make();
    public static final String SYNTHETIC_CALL_METHOD_PREFIX = "$$ call_";

    public JavaScriptFunctionDotCallTargetSelector(MethodTargetSelector base) {
        this.base = base;
    }

    public IMethod getCalleeTarget(CGNode caller, CallSiteReference site, IClass receiver) {
        TypeName tn;
        IMethod method = receiver.getMethod(AstMethodReference.fnSelector);
        if (method != null && (tn = method.getReference().getDeclaringClass().getName()).equals((Object)CALL_TYPE_NAME)) {
            IMethod target;
            if (!site.getDeclaredTarget().equals((Object)JavaScriptMethods.ctorReference) && (target = this.getFunctionCallTarget(caller, site, receiver)) != null) {
                return target;
            }
            if (WARN_ABOUT_IMPRECISE_CALLGRAPH) {
                this.warnAboutImpreciseCallGraph(caller, site);
            }
        }
        return this.base.getCalleeTarget(caller, site, receiver);
    }

    protected void warnAboutImpreciseCallGraph(CGNode caller, CallSiteReference site) {
        IntIterator indices = caller.getIR().getCallInstructionIndices(site).intIterator();
        IMethod callerMethod = caller.getMethod();
        CAstSourcePositionMap.Position pos = null;
        if (indices.hasNext() && callerMethod instanceof AstMethod) {
            pos = ((AstMethod)callerMethod).getSourcePosition(indices.next());
        }
        System.err.println("Detected improbable call to Function.prototype.call " + (pos == null ? "in function " + caller : "at position " + pos) + "; this is likely caused by call graph imprecision.");
    }

    private IMethod getFunctionCallTarget(CGNode caller, CallSiteReference site, IClass receiver) {
        int nargs = this.getNumberOfArgsPassed(caller, site);
        if (nargs < 2) {
            return null;
        }
        String key = this.getKey(nargs, caller, site);
        if (this.callModels.containsKey(key)) {
            return (IMethod)this.callModels.get(key);
        }
        JSInstructionFactory insts = (JSInstructionFactory)receiver.getClassLoader().getInstructionFactory();
        MethodReference ref = this.genSyntheticMethodRef(receiver, nargs, key);
        JavaScriptSummary S = new JavaScriptSummary(ref, nargs);
        if (WARN_ABOUT_IMPRECISE_CALLGRAPH && caller.getMethod().getName().toString().contains(SYNTHETIC_CALL_METHOD_PREFIX)) {
            this.warnAboutImpreciseCallGraph(caller, site);
        }
        int resultVal = nargs + 2;
        JSCallSiteReference cs = new JSCallSiteReference(S.getNextProgramCounter());
        int[] params = new int[nargs - 2];
        for (int i = 0; i < params.length; ++i) {
            params[i] = i + 3;
        }
        S.addStatement((SSAInstruction)insts.Invoke(S.getNumberOfStatements(), 2, resultVal, params, resultVal + 1, (CallSiteReference)cs));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.ReturnInstruction(S.getNumberOfStatements(), resultVal, false));
        S.getNextProgramCounter();
        JavaScriptSummarizedFunction t = new JavaScriptSummarizedFunction(ref, S, receiver);
        this.callModels.put(key, t);
        return t;
    }

    private MethodReference genSyntheticMethodRef(IClass receiver, int nargs, String key) {
        Atom atom = Atom.findOrCreateUnicodeAtom((String)(SYNTHETIC_CALL_METHOD_PREFIX + key));
        Descriptor desc = Descriptor.findOrCreateUTF8((Language)JavaScriptLoader.JS, (String)"()LRoot;");
        MethodReference ref = MethodReference.findOrCreate((TypeReference)receiver.getReference(), (Atom)atom, (Descriptor)desc);
        return ref;
    }

    private String getKey(int nargs, CGNode caller, CallSiteReference site) {
        return "" + nargs;
    }

    private int getNumberOfArgsPassed(CGNode caller, CallSiteReference site) {
        IR callerIR = caller.getIR();
        SSAAbstractInvokeInstruction[] callStmts = callerIR.getCalls(site);
        assert (callStmts.length == 1);
        int nargs = callStmts[0].getNumberOfParameters();
        return nargs;
    }
}

