/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ipa.callgraph;

import com.ibm.wala.cast.ir.ssa.AbstractReflectiveGet;
import com.ibm.wala.cast.ir.ssa.AstIsDefinedInstruction;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.SelectiveCPAContext;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.ReflectiveMemberAccess;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class PropertyNameContextSelector
implements ContextSelector {
    public static final ContextKey PROPNAME_KEY = new ContextKey(){};
    public static final ContextItem PROPNAME_MARKER = new ContextItem(){};
    public static final ContextKey PROPNAME_PARM_INDEX = new ContextKey(){};
    private final AnalysisCache cache;
    private final ContextSelector base;
    private final int index;
    private final HashMap<MethodReference, Frequency> usesFirstArgAsPropertyName_cache = HashMapFactory.make();

    private void collectValues(DefUse du, SSAInstruction inst, MutableIntSet values) {
        if (inst instanceof SSAGetInstruction) {
            SSAGetInstruction g = (SSAGetInstruction)inst;
            values.add(g.getRef());
            if (g.getRef() != -1) {
                this.collectValues(du, du.getDef(g.getRef()), values);
            }
        } else if (inst instanceof AbstractReflectiveGet) {
            AbstractReflectiveGet g = (AbstractReflectiveGet)inst;
            values.add(g.getObjectRef());
            this.collectValues(du, du.getDef(g.getObjectRef()), values);
            values.add(g.getMemberRef());
            this.collectValues(du, du.getDef(g.getMemberRef()), values);
        }
    }

    private IntSet identifyDependentParameters(CGNode caller, CallSiteReference site) {
        MutableIntSet dependentParameters = IntSetUtil.make();
        SSAAbstractInvokeInstruction inst = caller.getIR().getCalls(site)[0];
        DefUse du = caller.getDU();
        for (int i = 0; i < inst.getNumberOfParameters(); ++i) {
            MutableIntSet values = IntSetUtil.make();
            values.add(inst.getUse(i));
            this.collectValues(du, du.getDef(inst.getUse(i)), values);
            if (!values.contains(this.index + 1)) continue;
            dependentParameters.add(i);
        }
        return dependentParameters;
    }

    public PropertyNameContextSelector(AnalysisCache cache, ContextSelector base) {
        this(cache, 2, base);
    }

    public PropertyNameContextSelector(AnalysisCache cache, int index, ContextSelector base) {
        this.cache = cache;
        this.index = index;
        this.base = base;
    }

    private Frequency usesFirstArgAsPropertyName(IMethod method) {
        MethodReference mref = method.getReference();
        if (method.getNumberOfParameters() < this.index) {
            return Frequency.NEVER;
        }
        Frequency f = this.usesFirstArgAsPropertyName_cache.get(mref);
        if (f != null) {
            return f;
        }
        boolean usedAsPropertyName = false;
        boolean usedAsSomethingElse = false;
        DefUse du = this.cache.getDefUse(this.cache.getIR(method));
        for (SSAInstruction use : Iterator2Iterable.make((Iterator)du.getUses(this.index + 1))) {
            AstIsDefinedInstruction aidi;
            if (use instanceof ReflectiveMemberAccess) {
                ReflectiveMemberAccess rma = (ReflectiveMemberAccess)use;
                if (rma.getMemberRef() == this.index + 1) {
                    usedAsPropertyName = true;
                    continue;
                }
            } else if (use instanceof AstIsDefinedInstruction && (aidi = (AstIsDefinedInstruction)use).getNumberOfUses() > 1 && aidi.getUse(1) == this.index + 1) {
                usedAsPropertyName = true;
                continue;
            }
            usedAsSomethingElse = true;
        }
        f = !usedAsPropertyName ? Frequency.NEVER : (usedAsSomethingElse ? Frequency.SOMETIMES : Frequency.ALWAYS);
        this.usesFirstArgAsPropertyName_cache.put(mref, f);
        return f;
    }

    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] receiver) {
        Frequency f;
        Context baseContext = this.base.getCalleeTarget(caller, site, callee, receiver);
        if (receiver.length > this.index && receiver[this.index] instanceof ConstantKey && ((f = this.usesFirstArgAsPropertyName(callee)) == Frequency.ALWAYS || f == Frequency.SOMETIMES)) {
            return new PropNameContext(baseContext, receiver[this.index]);
        }
        if (PROPNAME_MARKER.equals(caller.getContext().get(PROPNAME_KEY))) {
            if (!this.identifyDependentParameters(caller, site).isEmpty()) {
                InstanceKey callerIk = ((PropNameContext)caller.getContext()).getInstanceKey();
                return new MarkerForInContext(baseContext, callerIk);
            }
            return baseContext;
        }
        return baseContext;
    }

    public IntSet getRelevantParameters(CGNode caller, CallSiteReference site) {
        if (caller.getIR().getCalls(site)[0].getNumberOfUses() > this.index) {
            return IntSetUtil.make((int[])new int[]{this.index}).union(this.base.getRelevantParameters(caller, site));
        }
        return this.base.getRelevantParameters(caller, site);
    }

    private static enum Frequency {
        NEVER,
        SOMETIMES,
        ALWAYS;

    }

    class MarkerForInContext
    extends PropNameContext {
        MarkerForInContext(Context base, InstanceKey obj) {
            super(base, obj);
        }

        @Override
        public ContextItem get(ContextKey key) {
            ContextItem contextItem = super.get(key);
            return contextItem instanceof FilteredPointerKey.SingleInstanceFilter ? null : contextItem;
        }

        @Override
        public InstanceKey getInstanceKey() {
            return ((FilteredPointerKey.SingleInstanceFilter)super.get(ContextKey.PARAMETERS[PropertyNameContextSelector.this.index])).getInstance();
        }
    }

    public class PropNameContext
    extends SelectiveCPAContext {
        PropNameContext(Context base, InstanceKey obj) {
            super(base, Collections.singletonMap(ContextKey.PARAMETERS[PropertyNameContextSelector.this.index], obj));
        }

        public ContextItem get(ContextKey key) {
            if (PROPNAME_KEY.equals(key)) {
                return PROPNAME_MARKER;
            }
            if (PROPNAME_PARM_INDEX.equals(key)) {
                return ContextItem.Value.make((Object)PropertyNameContextSelector.this.index);
            }
            return super.get(key);
        }

        public String toString() {
            return "property name context for " + this.get(ContextKey.PARAMETERS[PropertyNameContextSelector.this.index]) + " over " + this.base;
        }

        public InstanceKey getInstanceKey() {
            return ((FilteredPointerKey.SingleInstanceFilter)this.get(ContextKey.PARAMETERS[PropertyNameContextSelector.this.index])).getInstance();
        }
    }
}

