/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ipa.callgraph.correlations;

import com.ibm.wala.cast.ipa.callgraph.CAstAnalysisScope;
import com.ibm.wala.cast.ir.ssa.AbstractReflectiveGet;
import com.ibm.wala.cast.ir.ssa.AbstractReflectivePut;
import com.ibm.wala.cast.ir.ssa.AstIRFactory;
import com.ibm.wala.cast.ir.translator.TranslatorToCAst;
import com.ibm.wala.cast.js.html.DefaultSourceExtractor;
import com.ibm.wala.cast.js.html.WebUtil;
import com.ibm.wala.cast.js.ipa.callgraph.JSCallGraphUtil;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.CorrelationSummary;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.EscapeCorrelation;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.ReadWriteCorrelation;
import com.ibm.wala.cast.js.loader.JavaScriptLoader;
import com.ibm.wala.cast.js.loader.JavaScriptLoaderFactory;
import com.ibm.wala.cast.js.translator.JavaScriptTranslatorFactory;
import com.ibm.wala.cast.js.util.Util;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.loader.SingleClassLoaderFactory;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.SourceModule;
import com.ibm.wala.classLoader.SourceURLModule;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRFactory;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.ObjectArrayMapping;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import com.ibm.wala.util.io.FileProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class CorrelationFinder {
    private static final boolean TRACK_ESCAPES = true;
    private static final boolean IGNORE_NUMERIC_INDICES = false;
    private final JavaScriptTranslatorFactory translatorFactory;

    public CorrelationFinder(JavaScriptTranslatorFactory translatorFactory) {
        this.translatorFactory = translatorFactory;
    }

    public static CorrelationSummary findCorrelatedAccesses(IMethod method, IR ir) {
        AstMethod astMethod = (AstMethod)method;
        DefUse du = new DefUse(ir);
        ObjectArrayMapping instrIndices = new ObjectArrayMapping((Object[])ir.getInstructions());
        CorrelationSummary summary = new CorrelationSummary(method, (OrdinalSetMapping<SSAInstruction>)instrIndices);
        LinkedList<AbstractReflectivePut> puts = new LinkedList<AbstractReflectivePut>();
        for (SSAInstruction inst : Iterator2Iterable.make((Iterator)ir.iterateNormalInstructions())) {
            if (!(inst instanceof AbstractReflectivePut)) continue;
            puts.addFirst((AbstractReflectivePut)inst);
        }
        SSAInstruction[] insts = ir.getInstructions();
        block1: for (int ii = 0; ii < insts.length; ++ii) {
            String indexName;
            SSAInstruction inst = insts[ii];
            if (!(inst instanceof AbstractReflectiveGet)) continue;
            AbstractReflectiveGet get = (AbstractReflectiveGet)inst;
            int index = get.getMemberRef();
            if (ir.getSymbolTable().isConstant(index) || ir.getSymbolTable().isParameter(index) || (indexName = CorrelationFinder.getSourceLevelName(ir, ii, index)) == null) continue;
            AstMethod.LexicalInformation lexicalInfo = astMethod.lexicalInfo();
            if (lexicalInfo.getExposedNames() != null) {
                for (Pair n : lexicalInfo.getExposedNames()) {
                    if (((String)n.fst).equals(indexName) && lexicalInfo.getScopingName().equals(n.snd)) continue block1;
                }
            }
            BitVectorIntSet reached = new BitVectorIntSet();
            reached.add(get.getDef());
            LinkedList<Integer> worklist = new LinkedList<Integer>();
            BitVectorIntSet done = new BitVectorIntSet();
            worklist.add(get.getDef());
            while (!worklist.isEmpty()) {
                Integer i = (Integer)worklist.pop();
                done.add(i.intValue());
                block4: for (SSAInstruction inst2 : Iterator2Iterable.make((Iterator)du.getUses(i.intValue()))) {
                    int def;
                    int i2 = instrIndices.getMappedIndex((Object)inst2);
                    if (inst2 instanceof SSAPhiInstruction) {
                        def = inst2.getDef();
                        if (!reached.add(def) || done.contains(def)) continue;
                        worklist.add(def);
                        continue;
                    }
                    if (!(inst2 instanceof SSAAbstractInvokeInstruction)) continue;
                    def = inst2.getDef();
                    if (reached.add(def) && !done.contains(def)) {
                        worklist.add(def);
                    }
                    for (int j = 0; j < inst2.getNumberOfUses(); ++j) {
                        if (inst2.getUse(j) != index) continue;
                        summary.addCorrelation(new EscapeCorrelation(get, (SSAAbstractInvokeInstruction)inst2, indexName, CorrelationFinder.getSourceLevelNames(ir, i2, (IntSet)reached)));
                        continue block4;
                    }
                }
            }
            for (AbstractReflectivePut put : puts) {
                if (put.getMemberRef() != index || !reached.contains(put.getValue())) continue;
                summary.addCorrelation(new ReadWriteCorrelation(get, put, indexName, CorrelationFinder.getSourceLevelNames(ir, ii, (IntSet)reached)));
            }
        }
        return summary;
    }

    private static String getSourceLevelName(IR ir, int index, int vn) {
        String indexName = null;
        String[] sourceNamesForValues = ir.getLocalNames(index, vn);
        if (sourceNamesForValues == null) {
            return null;
        }
        for (String candidateName : sourceNamesForValues) {
            if (indexName != null) {
                indexName = null;
                break;
            }
            if (candidateName.contains(" ")) continue;
            indexName = candidateName;
        }
        return indexName;
    }

    private static Set<String> getSourceLevelNames(IR ir, int index, IntSet vs) {
        HashSet<String> res = new HashSet<String>();
        IntIterator iter = vs.intIterator();
        while (iter.hasNext()) {
            String name = CorrelationFinder.getSourceLevelName(ir, index, iter.next());
            if (name == null) continue;
            res.add(name);
        }
        return res;
    }

    private static boolean mustBeNumeric(IR ir, DefUse du, int v) {
        LinkedList<Integer> worklist = new LinkedList<Integer>();
        BitVectorIntSet done = new BitVectorIntSet();
        worklist.add(v);
        while (!worklist.isEmpty()) {
            int i = (Integer)worklist.pop();
            done.add(i);
            if (ir.getSymbolTable().isConstant(i) && ir.getSymbolTable().getConstantValue(i) instanceof Number) continue;
            SSAInstruction inst2 = du.getDef(i);
            if (inst2 instanceof SSAPhiInstruction) {
                for (int j = 0; j < inst2.getNumberOfUses(); ++j) {
                    int use = inst2.getUse(j);
                    if (done.contains(use)) continue;
                    worklist.add(use);
                }
                continue;
            }
            if (inst2 instanceof SSABinaryOpInstruction) {
                IBinaryOpInstruction.IOperator operator = ((SSABinaryOpInstruction)inst2).getOperator();
                if (operator != IBinaryOpInstruction.Operator.ADD) continue;
                for (int j = 0; j < inst2.getNumberOfUses(); ++j) {
                    int use = inst2.getUse(j);
                    if (done.contains(use)) continue;
                    worklist.add(use);
                }
                continue;
            }
            return false;
        }
        return true;
    }

    private void printCorrelatedAccesses(URL url) throws IOException, ClassHierarchyException {
        this.printCorrelatedAccesses(this.findCorrelatedAccesses(url));
    }

    private void printCorrelatedAccesses(Map<IMethod, CorrelationSummary> summaries) {
        ArrayList<Pair<CAstSourcePositionMap.Position, String>> correlations = new ArrayList<Pair<CAstSourcePositionMap.Position, String>>();
        for (CorrelationSummary summary : summaries.values()) {
            correlations.addAll(summary.pp());
        }
        Collections.sort(correlations, new Comparator<Pair<CAstSourcePositionMap.Position, String>>(){

            @Override
            public int compare(Pair<CAstSourcePositionMap.Position, String> o1, Pair<CAstSourcePositionMap.Position, String> o2) {
                return ((CAstSourcePositionMap.Position)o1.fst).compareTo(o2.fst);
            }
        });
        int i = 0;
        for (Pair pair : correlations) {
            System.out.println(i++ + " -- " + pair.fst + ": " + (String)pair.snd);
        }
    }

    public Map<IMethod, CorrelationSummary> findCorrelatedAccesses(URL url) throws IOException, ClassHierarchyException {
        Set scripts;
        block4: {
            scripts = null;
            if (url.getPath().endsWith(".js")) {
                scripts = Collections.singleton(new SourceURLModule(url));
            } else {
                JavaScriptLoader.addBootstrapFile("preamble.js");
                try {
                    scripts = (Set)WebUtil.extractScriptFromHTML((URL)url, DefaultSourceExtractor.factory).fst;
                }
                catch (TranslatorToCAst.Error e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError(e.warning);
                }
            }
        }
        Map<IMethod, CorrelationSummary> summaries = this.findCorrelatedAccesses(scripts);
        return summaries;
    }

    public Map<IMethod, CorrelationSummary> findCorrelatedAccesses(Collection<? extends SourceModule> scripts) throws IOException, ClassHierarchyException {
        return this.findCorrelatedAccesses(scripts.toArray(new SourceModule[scripts.size()]));
    }

    public Map<IMethod, CorrelationSummary> findCorrelatedAccesses(SourceModule[] scripts_array) throws IOException, ClassHierarchyException {
        JSCallGraphUtil.setTranslatorFactory(this.translatorFactory);
        JavaScriptLoaderFactory loaders = JSCallGraphUtil.makeLoaders(null);
        CAstAnalysisScope scope = new CAstAnalysisScope(scripts_array, (SingleClassLoaderFactory)loaders, Collections.singleton(JavaScriptLoader.JS));
        ClassHierarchy cha = ClassHierarchy.make((AnalysisScope)scope, (ClassLoaderFactory)loaders, (Language)JavaScriptLoader.JS);
        try {
            Util.checkForFrontEndErrors((IClassHierarchy)cha);
        }
        catch (WalaException e) {
            return Collections.emptyMap();
        }
        IRFactory factory = AstIRFactory.makeDefaultFactory();
        HashMap correlations = HashMapFactory.make();
        for (IClass klass : cha) {
            for (IMethod method : klass.getAllMethods()) {
                IR ir;
                CorrelationSummary summary = CorrelationFinder.findCorrelatedAccesses(method, ir = factory.makeIR(method, (Context)Everywhere.EVERYWHERE, SSAOptions.defaultOptions()));
                if (summary.getCorrelations().isEmpty()) continue;
                correlations.put(method, summary);
            }
        }
        return correlations;
    }

    private URL toUrl(String src) throws MalformedURLException {
        try {
            File f = new FileProvider().getFileFromClassLoader(src, this.getClass().getClassLoader());
            URL url = f.toURI().toURL();
            return url;
        }
        catch (FileNotFoundException fnfe) {
            return new URL(src);
        }
    }
}

