/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ssa;

import com.ibm.wala.cast.js.ssa.JSInstructionFactory;
import com.ibm.wala.cast.js.ssa.JSInstructionVisitor;
import com.ibm.wala.cast.js.types.JavaScriptTypes;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Collections;

public class JavaScriptInstanceOf
extends SSAInstruction {
    private final int objVal;
    private final int typeVal;
    private final int result;

    public JavaScriptInstanceOf(int iindex, int result, int objVal, int typeVal) {
        super(iindex);
        this.objVal = objVal;
        this.typeVal = typeVal;
        this.result = result;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        return ((JSInstructionFactory)insts).InstanceOf(this.iindex, defs == null ? this.result : defs[0], uses == null ? this.objVal : uses[0], uses == null ? this.typeVal : uses[1]);
    }

    public Collection<TypeReference> getExceptionTypes() {
        return Collections.singleton(JavaScriptTypes.TypeError);
    }

    public boolean isPEI() {
        return true;
    }

    public int hashCode() {
        return this.objVal * 31771 + this.typeVal * 23 + this.result;
    }

    public boolean isFallThrough() {
        return true;
    }

    public String toString(SymbolTable symbolTable) {
        return this.getValueString(symbolTable, this.result) + " = " + this.getValueString(symbolTable, this.objVal) + " is instance of " + this.getValueString(symbolTable, this.typeVal);
    }

    public void visit(SSAInstruction.IVisitor v) {
        ((JSInstructionVisitor)v).visitJavaScriptInstanceOf(this);
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public int getDef(int i) {
        assert (i == 0);
        return this.result;
    }

    public int getNumberOfUses() {
        return 2;
    }

    public int getUse(int i) {
        switch (i) {
            case 0: {
                return this.objVal;
            }
            case 1: {
                return this.typeVal;
            }
        }
        Assertions.UNREACHABLE();
        return -1;
    }
}

