/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ssa;

import com.ibm.wala.cast.js.ssa.JSInstructionFactory;
import com.ibm.wala.cast.js.ssa.JSInstructionVisitor;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import java.util.Collection;

public class JavaScriptWithRegion
extends SSAInstruction {
    private final int expr;
    private final boolean isEnter;

    public JavaScriptWithRegion(int iindex, int expr, boolean isEnter) {
        super(iindex);
        this.expr = expr;
        this.isEnter = isEnter;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        return ((JSInstructionFactory)insts).WithRegion(this.iindex, uses == null ? this.expr : uses[0], this.isEnter);
    }

    public Collection<TypeReference> getExceptionTypes() {
        return null;
    }

    public int hashCode() {
        return 353456 * this.expr * (this.isEnter ? 1 : -1);
    }

    public boolean isFallThrough() {
        return true;
    }

    public String toString(SymbolTable symbolTable) {
        return (this.isEnter ? "enter" : "exit") + " of with " + this.getValueString(symbolTable, this.expr);
    }

    public void visit(SSAInstruction.IVisitor v) {
        ((JSInstructionVisitor)v).visitWithRegion(this);
    }

    public int getNumberOfUses() {
        return 1;
    }

    public int getUse(int i) {
        assert (i == 0);
        return this.expr;
    }
}

