/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.common.scm;

import com.hcl.appscan.common.scm.IScmProvider;
import com.hcl.appscan.common.scm.IScmProviderFactory;
import com.hcl.appscan.common.scm.NullScmProvider;
import com.hcl.appscan.common.scm.ScmSettingsReader;
import com.ibm.appscan.common.IProgress;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.ServiceLoader;

public class ScmFactory {
    private static final ServiceLoader<IScmProviderFactory> LOADER = ServiceLoader.load(IScmProviderFactory.class);

    public static IScmProvider getScmProviderForDirectory(File directory, IProgress progress) {
        for (IScmProviderFactory factory : LOADER) {
            IScmProvider provider = factory.initializeFromDirectory(directory, progress);
            if (provider == null) continue;
            return provider;
        }
        return new NullScmProvider();
    }

    public static IScmProvider getScmProviderFromSettingsFile(File settingsFile) throws IOException {
        Properties properties = new ScmSettingsReader(settingsFile).getProperties();
        for (IScmProviderFactory factory : LOADER) {
            if (!factory.getName().equalsIgnoreCase(properties.getProperty("name"))) continue;
            return factory.createProvider(properties);
        }
        return new NullScmProvider();
    }
}

