/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.build;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.build.BuilderDefinition;
import java.util.Map;

public abstract class BuilderType<T extends BuilderDefinition> {
    private String m_name;
    private Class<T> m_definition;

    public BuilderType(String name, Class<T> definition) {
        this.m_name = name;
        this.m_definition = definition;
    }

    public final String getName() {
        return this.m_name;
    }

    public final String getID() {
        return this.m_definition.getName();
    }

    protected Map<String, String> canHandle(String value) {
        return null;
    }

    public abstract T create();

    public final T autoCreate(String value) {
        BuilderDefinition builder;
        if (CommonCore.getBuildManager().hasBuilder(value) && this.m_definition.isInstance(builder = CommonCore.getBuildManager().getBuilder(value))) {
            return (T)((BuilderDefinition)this.m_definition.cast(builder));
        }
        Map<String, String> properties = this.canHandle(value);
        if (properties == null) {
            return null;
        }
        T builder2 = this.create();
        if (!CommonCore.getBuildManager().register(value, (BuilderDefinition)builder2, properties)) {
            return null;
        }
        return builder2;
    }
}

