/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.logging;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Messages;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.utils.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class LogMerger {
    private String m_file_name;
    private File m_merged_file;
    private boolean m_has_log_file_to_merge = false;
    private ILogManager m_logManager;
    private File m_workLocation;
    private IScan m_scan;

    public LogMerger(File destination, String fileName, IScan scan) throws IOException {
        this(destination, fileName, scan.getLogManager(), scan.getSaveLocation().getWorkLocation(), scan);
    }

    public LogMerger(File destination, String fileName, ILogManager logManager, File workLocation) throws IOException {
        this.m_file_name = fileName;
        this.m_merged_file = new File(destination, this.getNewFileName(fileName));
        this.m_logManager = logManager;
        this.m_workLocation = workLocation;
        this.visitAndMergeFile();
    }

    public LogMerger(File destination, String fileName, ILogManager logManager, File workLocation, IScan scan) throws IOException {
        this.m_scan = scan;
        this.m_file_name = fileName;
        this.m_merged_file = new File(destination, this.getNewFileName(fileName));
        this.m_logManager = logManager;
        this.m_workLocation = workLocation;
        this.visitAndMergeFile();
    }

    protected ILogManager getLogManager() {
        return this.m_logManager;
    }

    protected File getWorkLocation() {
        return this.m_workLocation;
    }

    protected String getFileName() {
        return this.m_file_name;
    }

    protected String getNewFileName(String supplied_name) {
        return supplied_name.substring(0, supplied_name.lastIndexOf(".")) + ".slice.log";
    }

    protected IScan getScan() {
        return this.m_scan;
    }

    public File getMergedFile() throws IOException {
        return this.m_merged_file;
    }

    protected void visitAndMergeFile() throws IOException {
        try {
            Path path = this.getMergedFile().getParentFile().getParentFile().toPath();
            Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toFile().getName().equals(LogMerger.this.m_file_name)) {
                        LogMerger.this.m_has_log_file_to_merge = true;
                        LogMerger.this.append(file.toFile());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException exp) {
            CommonCore.getLogManager().log(exp);
        }
    }

    public boolean hasEntriesToMerge() throws IOException {
        this.m_has_log_file_to_merge = false;
        try {
            Files.walkFileTree(this.getMergedFile().getParentFile().getParentFile().toPath(), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toFile().getName().equals(LogMerger.this.m_file_name)) {
                        LogMerger.this.m_has_log_file_to_merge = true;
                    }
                    return FileVisitResult.TERMINATE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException exp) {
            this.m_logManager.log(exp);
        }
        return this.m_has_log_file_to_merge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(File file) throws IOException {
        if (file.exists() && file.isFile() && file.length() > 0L) {
            StringBuilder str = new StringBuilder();
            str.append(Messages.getMessage("slice.log.boundary", new Object[0]));
            str.append(System.lineSeparator());
            str.append(Messages.getMessage("slice.log", file.getParentFile().getParentFile().getName()));
            str.append(System.lineSeparator());
            String path = file.getAbsolutePath();
            if (file.getAbsolutePath().startsWith(this.m_workLocation.getAbsolutePath())) {
                path = file.getAbsolutePath().substring(this.m_workLocation.getAbsolutePath().length() + 1);
            }
            str.append(Messages.getMessage("slice.log.location", path));
            str.append(System.lineSeparator());
            IOUtil.write(str.toString(), this.m_merged_file, true);
            BufferedInputStream log_file = null;
            try {
                log_file = new BufferedInputStream(new FileInputStream(file));
                IOUtil.write(log_file, this.m_merged_file, true);
            }
            catch (Throwable throwable) {
                IOUtil.close(log_file);
                throw throwable;
            }
            IOUtil.close(log_file);
        }
    }

    public static class Unzipper {
        public static final String DOT_ZIP = ".ZIP";
        public final FilenameFilter DOT_ZIP_FILTER = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(Unzipper.DOT_ZIP);
            }
        };

        public void unzipDir(File dir) {
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    this.unzipDir(file);
                    continue;
                }
                if (!file.getName().endsWith(".zip")) continue;
                this.unzip(file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unzip(File file) {
            File dir = this.getZipDir(file);
            ZipFile zip = null;
            try {
                dir.mkdirs();
                zip = new ZipFile(file, Charset.defaultCharset());
                Enumeration<? extends ZipEntry> zipEntries = zip.entries();
                while (zipEntries.hasMoreElements()) {
                    ZipEntry zipEntry = zipEntries.nextElement();
                    File outputFile = new File(dir, zipEntry.getName());
                    outputFile.getParentFile().mkdirs();
                    if (zipEntry.isDirectory()) continue;
                    this.write(zip, zipEntry, outputFile);
                }
            }
            catch (Exception e) {
                try {
                    CommonCore.getLogManager().log(e);
                    dir.delete();
                }
                catch (Throwable throwable) {
                    IOUtil.close(zip);
                    throw throwable;
                }
                IOUtil.close(zip);
            }
            IOUtil.close(zip);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void write(ZipFile zip, ZipEntry zipEntry, File outputFile) throws IOException {
            BufferedInputStream input = null;
            int buffsize = 1024;
            byte[] buffer = new byte[buffsize];
            BufferedOutputStream output = null;
            try {
                input = new BufferedInputStream(zip.getInputStream(zipEntry));
                output = new BufferedOutputStream(new FileOutputStream(outputFile));
                while (input.available() > 0) {
                    input.read(buffer, 0, buffsize);
                    output.write(buffer, 0, buffsize);
                }
                output.flush();
            }
            catch (Throwable throwable) {
                IOUtil.close(output);
                IOUtil.close(input);
                throw throwable;
            }
            IOUtil.close(output);
            IOUtil.close(input);
        }

        protected File getZipDir(File zip) {
            File dir = zip.getParentFile();
            int index = zip.getName().toUpperCase().lastIndexOf(DOT_ZIP);
            String zipPath = zip.getName().substring(0, index);
            File zipDir = new File(dir, zipPath);
            return zipDir;
        }
    }
}

