/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.logging;

import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.security.annotation.SuppressSecurityTrace;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class Message {
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int TRACE = 3;
    public static final int ERROR = 4;
    public static final int IPVA = 5;
    public static final int SCAN = 6;
    public static final String[] SEV_STRINGS = new String[]{"INFO", "WARNING", "TRACE", "ERROR", "IPVA", "SCAN"};
    private int m_severity = 1;
    private Date m_timestamp;
    private String m_text;
    private String m_helpID = null;
    private MessageSource m_source = null;
    private Throwable m_throwable = null;

    public Message(int severity, String text) {
        this(severity, new Date(), text);
    }

    public Message(int severity, Date timestamp, String text) {
        if (severity == 2 || severity == 4 || severity == 3 || severity == 5 || severity == 6) {
            this.m_severity = severity;
        }
        this.m_timestamp = timestamp;
        this.m_text = text;
    }

    public Message(Throwable throwable) {
        this(throwable.getMessage() == null ? throwable.getClass().getName() : throwable.getMessage(), throwable);
    }

    public Message(String text, Throwable throwable) {
        this(4, text);
        this.m_throwable = throwable;
    }

    public int getSeverity() {
        return this.m_severity;
    }

    public Date getTimestamp() {
        return this.m_timestamp;
    }

    public String getText() {
        if (this.m_throwable != null && SystemUtil.isDebug()) {
            StringBuilder str = new StringBuilder();
            for (StackTraceElement ee : this.m_throwable.getStackTrace()) {
                str.append(ee.toString());
                str.append(System.lineSeparator());
            }
            str.append(this.m_throwable.getLocalizedMessage());
            return this.m_text + System.lineSeparator() + str.toString();
        }
        return this.m_text;
    }

    public Throwable getThrowable() {
        return this.m_throwable;
    }

    public StackTraceElement[] getStackTrace() {
        if (this.m_throwable == null) {
            return null;
        }
        return this.getThrowable().getStackTrace();
    }

    public void setHelpID(String helpID) {
        this.m_helpID = helpID;
    }

    public String getHelpID() {
        return this.m_helpID;
    }

    public void setMessageSource(MessageSource source) {
        this.m_source = source;
    }

    public String getTargetPath() {
        return this.m_source == null ? null : this.m_source.m_targetPath;
    }

    public String getBuildInfoKey() {
        return this.m_source == null ? null : this.m_source.m_buildInfoKey;
    }

    public String getFilePath() {
        return this.m_source == null ? null : this.m_source.m_filePath;
    }

    public int getLine() {
        return this.m_source == null ? 0 : this.m_source.m_line;
    }

    protected String getConciseSource() {
        String path = this.getFilePath();
        if (path == null) {
            path = this.getTargetPath();
        } else {
            int line = this.getLine();
            if (line > 0) {
                path = path + (58 + line);
            }
        }
        return path == null ? "" : " " + path;
    }

    private String firstLine() {
        return this.m_timestamp + " " + SEV_STRINGS[this.m_severity - 1] + this.getConciseSource();
    }

    public String toString() {
        return this.firstLine() + System.getProperty("line.separator") + this.m_text;
    }

    @SuppressSecurityTrace
    public void printTo(PrintWriter out) {
        out.println(this.firstLine());
        this.printExtra(out);
        if (this.m_throwable == null || !this.m_text.equals(this.m_throwable.getClass().getName()) && !this.m_text.equals(this.m_throwable.getMessage())) {
            out.println(this.m_text);
        }
        if (this.m_throwable != null) {
            this.m_throwable.printStackTrace(out);
        }
        out.println();
        out.flush();
    }

    protected void printExtra(PrintWriter out) {
    }

    public JSONObject toJson() throws JSONException {
        JSONObject ret = new JSONObject();
        this.addExtraJsonParts(ret);
        SimpleDateFormat dateFormatGmt = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss");
        dateFormatGmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat dateFormatLocal = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss");
        try {
            ret.put("timestamp", (Object)dateFormatLocal.parse(dateFormatGmt.format(this.getTimestamp())));
        }
        catch (ParseException e) {
            throw new JSONException((Throwable)e);
        }
        ret.put("severity", (Object)SEV_STRINGS[this.getSeverity() - 1]);
        if (this.getConciseSource() != null && this.getConciseSource().length() > 0) {
            ret.put("source", (Object)this.getConciseSource());
        }
        if (this.getThrowable() == null || !this.getText().equals(this.getThrowable().getClass().getName()) && !this.getText().equals(this.getThrowable().getMessage())) {
            ret.put("message", (Object)this.getText());
        }
        if (this.getThrowable() != null) {
            ret.put("trace", (Object[])this.getStackTrace());
        }
        return ret;
    }

    protected void addExtraJsonParts(JSONObject obj) throws JSONException {
    }

    public final class MessageSource {
        public static final int UNKNOWN = 0;
        private String m_targetPath = null;
        private String m_buildInfoKey = null;
        private String m_filePath = null;
        private int m_line = 0;

        public MessageSource(String targetPath, String buildInfoKey) {
            this.m_targetPath = targetPath;
            this.m_buildInfoKey = buildInfoKey;
        }

        public MessageSource(String targetPath, String filePath, int line) {
            this.m_targetPath = targetPath;
            this.m_filePath = filePath;
            this.m_line = line;
        }

        public MessageSource(String targetPath, String buildInfoKey, String filePath, int line) {
            this.m_targetPath = targetPath;
            this.m_buildInfoKey = buildInfoKey;
            this.m_filePath = filePath;
            this.m_line = line;
        }
    }
}

