/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.model;

import java.util.Collection;
import java.util.HashSet;

public class ProgressTracker {
    private double m_totalUnits;
    private double m_completedUnits;
    private Collection<ProgressTracker> m_childTrackers;

    public ProgressTracker() {
        this(0);
    }

    public ProgressTracker(int numUnits) {
        this.m_totalUnits = numUnits;
        this.m_completedUnits = 0.0;
        this.m_childTrackers = new HashSet<ProgressTracker>();
    }

    public void unitCompleted() {
        this.m_completedUnits += 1.0;
    }

    public void setComplete() {
        this.m_completedUnits = this.m_totalUnits;
        for (ProgressTracker child : this.m_childTrackers) {
            child.setComplete();
        }
    }

    public void addUnits(int numUnits) {
        this.m_totalUnits += (double)numUnits;
    }

    public void addChildTracker(ProgressTracker child) {
        this.m_childTrackers.add(child);
    }

    public int getPercentComplete() {
        return this.m_childTrackers.isEmpty() ? this.getPercentUnitsComplete() : this.getPercentChildrenComplete();
    }

    private int getPercentUnitsComplete() {
        if (this.m_totalUnits <= 0.0) {
            return 0;
        }
        if (this.m_completedUnits > this.m_totalUnits) {
            return 100;
        }
        double percent = this.m_completedUnits / this.m_totalUnits;
        return (int)(percent * 100.0);
    }

    private int getPercentChildrenComplete() {
        double percentComplete = 0.0;
        for (ProgressTracker child : this.m_childTrackers) {
            percentComplete += (double)child.getPercentComplete();
        }
        return (int)(percentComplete / (double)this.m_childTrackers.size());
    }
}

