/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.model;

import com.ibm.appscan.common.utils.SystemUtil;
import java.io.File;

public class SaveLocation {
    private static final int DEFAULT_LENGTH = 8;
    private File m_file;
    private File m_workLocation;

    public SaveLocation(File file) {
        this.m_file = file;
        String name = this.getShortName();
        int i = 1;
        do {
            String defaultScanHome;
            if ((defaultScanHome = SystemUtil.getDefaultScanHome()) == null) {
                defaultScanHome = file.getParent();
            }
            this.m_workLocation = new File(defaultScanHome, name + i++);
        } while (this.m_workLocation.exists());
    }

    private String getShortName() {
        String name = this.m_file.getName();
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(0, i);
        }
        if ((i = name.length()) > 8) {
            name = name.substring(i - 8);
        }
        return '_' + name + '_';
    }

    public File getFile() {
        return this.m_file;
    }

    public File getWorkLocation() {
        return this.m_workLocation;
    }

    public void copyWorkLocation(SaveLocation location) {
        this.m_workLocation = location.m_workLocation;
    }

    public String toString() {
        return this.m_file.toString();
    }
}

