/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.model;

import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanTarget;
import java.io.File;

public abstract class ScanModelVisitor {
    private boolean m_visitExcluded;
    private File m_directory = null;
    private File m_relPath = new File("/");

    public ScanModelVisitor() {
        this(false);
    }

    public ScanModelVisitor(boolean visitExcluded) {
        this.m_visitExcluded = visitExcluded;
    }

    public final boolean shouldVisitExcluded() {
        return this.m_visitExcluded;
    }

    public final void init(File directory) {
        if (this.m_directory == null) {
            this.m_directory = directory;
        }
    }

    public final File getWorkingDirectory() {
        if (this.m_directory != null) {
            return new File(this.m_directory, this.m_relPath.getPath());
        }
        return null;
    }

    protected final String getWorkingDirectoryPath() {
        String path = this.m_relPath.getPath();
        return path.substring(1).replace('\\', '/');
    }

    public void visit(IScan scan) {
    }

    public void postVisit(IScan scan) {
    }

    protected void visit(IScanTarget target) {
    }

    public final void internalVisit(IScanTarget target) {
        this.m_relPath = new File(this.m_relPath, target.getWorkingDirectoryName());
        this.visit(target);
    }

    protected void postVisit(IScanTarget target) {
    }

    public final void internalPostVisit(IScanTarget target) {
        this.postVisit(target);
        this.m_relPath = this.m_relPath.getParentFile();
    }
}

