/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.model.utils;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.model.IScanModelVisitable;
import com.ibm.appscan.common.model.SaveLocation;
import com.ibm.appscan.common.model.xml.ModelWriter;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class VisitingWriter {
    private IScanModelVisitable m_visitable;
    private File m_directory;
    private ModelWriter m_writer;
    private boolean m_initialized = false;

    public VisitingWriter(IScanModelVisitable visitable, SaveLocation location, ModelWriter writer) {
        this.m_visitable = visitable;
        this.m_directory = location.getWorkLocation();
        this.m_writer = writer;
    }

    public VisitingWriter(IScanModelVisitable visitable, File directory, ModelWriter writer) {
        this.m_visitable = visitable;
        this.m_directory = directory;
        this.m_writer = writer;
    }

    public synchronized void write(IProgress progress) throws IOException {
        try {
            if (!this.m_initialized) {
                this.m_writer.initialize(this.m_directory);
                this.m_visitable.accept(this.m_writer);
                this.m_initialized = true;
            }
            this.m_writer.write();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
    }
}

