/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Messages;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.DirectoryUtil;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.PathUtil;
import com.ibm.security.annotation.ValidatorMethod;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ArchiveUtil {
    private static final double TOO_BIG = 8.0E9;

    public static final List<ZipEntry> getZipEntries(ZipFile zipFile, Predicate<ZipEntry> match) {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        ArrayList<ZipEntry> lst = new ArrayList<ZipEntry>();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!match.test(entry)) continue;
            lst.add(entry);
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File[] files, File dest) throws IOException {
        ZipOutputStream zip = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(dest)));
        try {
            for (File file : files) {
                zip.putNextEntry(new ZipEntry(file.getName()));
                try {
                    IOUtil.write(file, zip);
                }
                finally {
                    zip.closeEntry();
                }
            }
        }
        finally {
            IOUtil.close(zip);
        }
    }

    public static void zip(File source, OutputStream dest) throws IOException {
        final ZipOutputStream zip = new ZipOutputStream(new BufferedOutputStream(dest));
        try {
            DirectoryUtil.walk(source, new DirectoryUtil.TreeVisitor(){

                @Override
                protected boolean preVisitDirectory(File directory) throws IOException {
                    if (new File(directory, ".appscanstaging").exists()) {
                        return false;
                    }
                    String path = this.getCurrentPath();
                    if (path.length() > 0) {
                        zip.putNextEntry(new ZipEntry(path));
                        zip.closeEntry();
                    }
                    return true;
                }

                @Override
                protected boolean visitFile(File file) throws IOException {
                    zip.putNextEntry(new ZipEntry(this.getCurrentPath()));
                    try {
                        IOUtil.write(file, zip);
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        zip.closeEntry();
                    }
                }
            });
        }
        finally {
            zip.finish();
            zip.flush();
        }
    }

    public static void zip(File source, File dest) throws IOException {
        FileOutputStream output = new FileOutputStream(dest);
        try {
            ArchiveUtil.zip(source, output);
        }
        finally {
            IOUtil.close(output);
        }
    }

    @ValidatorMethod
    public static List<Message> unzip(InputStream source, File dest, String ... files) throws IOException, AppScanException {
        return ArchiveUtil.unzip(source, dest, false, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValidatorMethod
    public static List<Message> unzip(InputStream source, File dest, boolean setPermissions, String ... files) throws IOException, AppScanException {
        ArrayList<Message> messages = new ArrayList<Message>();
        ZipInputStream zip = new ZipInputStream(new BufferedInputStream(source));
        dest.mkdirs();
        ArrayList<File> includes = new ArrayList<File>();
        if (files != null) {
            for (String file : files) {
                includes.add(new File(file));
            }
        }
        ZipEntry entry = null;
        long bytesWritten = 0L;
        try {
            while ((entry = zip.getNextEntry()) != null) {
                String path = entry.getName();
                File newFile = new File(dest, path);
                if (!PathUtil.isParent(dest, newFile)) {
                    throw new IOException(Messages.getMessage("err.invalid.path", path));
                }
                if (entry.isDirectory()) {
                    if (includes.isEmpty()) {
                        newFile.mkdirs();
                    }
                } else if (includes.isEmpty() || includes.contains(new File(path))) {
                    File parent = newFile.getParentFile();
                    parent.mkdirs();
                    if (parent.isDirectory()) {
                        bytesWritten += IOUtil.write(zip, newFile);
                    } else {
                        messages.add(new Message(2, Messages.getMessage("file.skipped", newFile)));
                    }
                }
                if ((double)bytesWritten >= 8.0E9) {
                    throw new AppScanException(Messages.getMessage("err.too.big", new Object[0]));
                }
                if (!setPermissions) continue;
                newFile.setExecutable(true, false);
                newFile.setReadable(true, false);
                newFile.setWritable(true);
            }
        }
        finally {
            IOUtil.close(zip);
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValidatorMethod
    public static List<Message> unzip(ZipFile zipFile, File dest, boolean setPermissions) throws IOException, AppScanException {
        ArrayList<Message> messages = new ArrayList<Message>();
        ZipEntry entry = null;
        long bytesWritten = 0L;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        try {
            while (entries.hasMoreElements()) {
                try {
                    entry = entries.nextElement();
                }
                catch (IllegalArgumentException e) {
                    CommonCore.getLogManager().log(new Message(Messages.getMessage("err.extract.entry", zipFile.getName()), e));
                    continue;
                }
                String path = entry.getName();
                File newFile = new File(dest, path);
                if (!PathUtil.isParent(dest, newFile)) {
                    throw new IOException(Messages.getMessage("err.invalid.path", path));
                }
                if (entry.isDirectory()) {
                    newFile.mkdirs();
                } else {
                    File parent = newFile.getParentFile();
                    parent.mkdirs();
                    if (parent.isDirectory()) {
                        bytesWritten += IOUtil.write(zipFile.getInputStream(entry), newFile);
                    } else {
                        messages.add(new Message(2, Messages.getMessage("file.skipped", newFile)));
                    }
                }
                if ((double)bytesWritten >= 8.0E9) {
                    throw new AppScanException(Messages.getMessage("err.too.big", new Object[0]));
                }
                if (!setPermissions) continue;
                newFile.setExecutable(true, false);
                newFile.setReadable(true, false);
                newFile.setWritable(true);
            }
        }
        finally {
            IOUtil.close(zipFile);
        }
        return messages;
    }

    public static List<Message> unzip(File source, File dest, String ... files) throws IOException, AppScanException {
        return ArchiveUtil.unzip(source, dest, false, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Message> unzip(File source, File dest, boolean setPermissions, String ... files) throws IOException, AppScanException {
        FileInputStream input = new FileInputStream(source);
        try {
            List<Message> list = ArchiveUtil.unzip((InputStream)input, dest, setPermissions, files);
            return list;
        }
        finally {
            IOUtil.close(input);
        }
    }

    public static boolean isZip(File file) {
        try {
            new ZipFile(file).close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void addFileToArchive(File archive, File sourceFile, String destination) throws IOException {
        ArchiveUtil.addFileToArchive(archive, Files.readAllBytes(sourceFile.toPath()), destination);
    }

    public static void addFileToArchive(File archive, String content, String destination) throws IOException {
        ArchiveUtil.addFileToArchive(archive, content.getBytes(), destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFileToArchive(File archive, byte[] bytes, String destination) throws IOException {
        URI uri = URI.create("jar:" + archive.toURI());
        FileSystem fs = FileSystems.newFileSystem(uri, new HashMap());
        try {
            Path dest = fs.getPath(destination, new String[0]);
            Files.write(dest, bytes, StandardOpenOption.CREATE);
        }
        finally {
            IOUtil.close(fs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFileFromArchive(File archive, String fileToRemove) throws IOException {
        URI uri = URI.create("jar:" + archive.toURI());
        FileSystem fs = FileSystems.newFileSystem(uri, new HashMap());
        try {
            Path dest = fs.getPath(fileToRemove, new String[0]);
            Files.delete(dest);
        }
        finally {
            IOUtil.close(fs);
        }
    }
}

