/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class FileUtil {
    private static String RESERVED_NAME_PATTERN = "(?i)(CON|PRN|AUX|NUL|COM0|COM1|COM2|COM3|COM4|COM5|COM6|COM7|COM8|COM9|LPT0|LPT1|LPT2|LPT3|LPT4|LPT5|LPT6|LPT7|LPT8|LPT9)(\\..*)?";

    public static boolean isHidden(File file) {
        return file.getName().startsWith(".");
    }

    public static boolean isValidFilename(String file) {
        File f = new File(file);
        try {
            f.getCanonicalPath();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String getBaseName(File file) {
        String name = file.getName();
        int i = name.lastIndexOf(".");
        if (i != -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    public static String getFileExtension(File file) {
        return FileUtil.getFileExtension(file.getName());
    }

    public static String getFileExtension(String fileName) {
        String extension = "";
        int i = fileName.lastIndexOf(".");
        if (i != -1 && i < fileName.length()) {
            extension = fileName.substring(i + 1, fileName.length());
        }
        return extension;
    }

    public static File getSiblingWithExt(File file, String ext) {
        return new File(file.getParentFile(), FileUtil.getBaseName(file) + ext);
    }

    public static ArrayList<File> getAllSubdirectories(File dir) {
        return FileUtil.getAllSubdirectories(dir, null);
    }

    public static ArrayList<File> getAllSubdirectories(File dir, String endsWithFilter) {
        ArrayList<File> ret = new ArrayList<File>();
        if (dir.isDirectory() && (endsWithFilter == null || !dir.getPath().endsWith(endsWithFilter))) {
            ret.add(dir);
            for (File f : dir.listFiles()) {
                ret.addAll(FileUtil.getAllSubdirectories(f));
            }
        }
        return ret;
    }

    public static File getFilesGivenRootAndRelativePath(File root, File relative) {
        return FileUtil.getFilesGivenRootAndRelativePath(root, relative, null);
    }

    public static File getFilesGivenRootAndRelativePath(File root, File relative, String endsWithFilter) {
        if (root == null) {
            return null;
        }
        for (File path : FileUtil.getAllSubdirectories(root, endsWithFilter)) {
            File test = new File(path, relative.getPath());
            if (test.exists()) {
                return test;
            }
            Path relative_path = Paths.get(relative.getPath(), new String[0]);
            if (relative_path.getNameCount() <= 1) continue;
            for (int i = 1; i < relative_path.getNameCount(); ++i) {
                test = new File(path, relative_path.subpath(i, relative_path.getNameCount()).toString());
                if (!test.exists()) continue;
                return test;
            }
        }
        return null;
    }

    public static String getByteStringFromFileSize(long size) {
        if (size < 1024L) {
            return size + " B";
        }
        int z = (63 - Long.numberOfLeadingZeros(size)) / 10;
        return String.format("%.1f %sB", (double)size / (double)(1L << z * 10), Character.valueOf(" KMGTPE".charAt(z)));
    }

    public static boolean isWinReservedName(String name) {
        return Pattern.matches(RESERVED_NAME_PATTERN, name);
    }

    public static boolean isWinReservedName(File filename) {
        return FileUtil.isWinReservedName(FileUtil.getBaseName(filename));
    }

    public static File checkAndModifyWinReservedName(String path) {
        String[] directories = path.split(Pattern.quote(FileSystems.getDefault().getSeparator()));
        Path newPath = Paths.get("", new String[0]);
        for (String dirName : directories) {
            if (FileUtil.isWinReservedName(new File(dirName))) {
                dirName = "_" + dirName;
            }
            newPath = Paths.get(newPath.toString(), dirName);
        }
        return newPath.toFile();
    }
}

