/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils;

import com.ibm.security.annotation.SuppressSecurityTrace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class IOUtil {
    private static final int BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, OutputStream output) throws IOException {
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
        int len = 0;
        byte[] buffer = new byte[4096];
        try {
            while ((len = input.read(buffer)) != -1) {
                output.write(buffer, 0, len);
            }
        }
        finally {
            IOUtil.close(input);
        }
    }

    @SuppressSecurityTrace
    public static long write(InputStream input, File file) throws IOException {
        return IOUtil.write(input, file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressSecurityTrace
    public static long write(InputStream input, File file, boolean append) throws IOException {
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file, append));
        long bytesWritten = 0L;
        int len = 0;
        byte[] buffer = new byte[4096];
        try {
            while ((len = input.read(buffer)) != -1) {
                output.write(buffer, 0, len);
                bytesWritten += (long)len;
            }
            output.flush();
            long l = bytesWritten;
            return l;
        }
        finally {
            IOUtil.close(output);
        }
    }

    public static void write(String string, File file) throws IOException {
        IOUtil.write(string, file, false);
    }

    public static void write(String string, File file, boolean append) throws IOException {
        IOUtil.write(new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)), file, append);
    }

    public static void write(Set<String> strings, File file) throws IOException {
        StringBuffer str = new StringBuffer();
        for (String s : strings) {
            str.append(s);
            str.append(System.getProperty("line.separator"));
        }
        IOUtil.write(str.toString(), file);
    }

    public static void write(List<String> strings, File file) throws IOException {
        StringBuffer str = new StringBuffer();
        for (String s : strings) {
            str.append(s);
            str.append(System.getProperty("line.separator"));
        }
        IOUtil.write(str.toString(), file);
    }

    public static ArrayList<String> readFileIntoStringArray(File file) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        for (String s : IOUtil.readFileIntoString(file).split("[\\r\\n]+")) {
            ret.add(s);
        }
        return ret;
    }

    public static ArrayList<String> readFileIntoSortedArray(File file) throws IOException {
        ArrayList<String> ret = IOUtil.readFileIntoStringArray(file);
        Collections.sort(ret);
        return ret;
    }

    public static String readFileIntoString(File file) throws IOException {
        return new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copy(File source, File dest) throws IOException {
        if (source.isDirectory()) {
            if (!dest.exists()) {
                dest.mkdirs();
            }
            File[] fileArray = source.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                IOUtil.copy(child, new File(dest, child.getName()));
                ++n2;
            }
            return;
        }
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            input = new FileInputStream(source);
            FileChannel sourceChannel = input.getChannel();
            output = new FileOutputStream(dest);
            FileChannel destChannel = output.getChannel();
            sourceChannel.transferTo(0L, source.length(), destChannel);
        }
        catch (Throwable throwable) {
            IOUtil.close(input);
            IOUtil.close(output);
            throw throwable;
        }
        IOUtil.close(input);
        IOUtil.close(output);
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static int getFileCountInDirForExtension(File dir, String ext) {
        int ret = 0;
        if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                ret += IOUtil.getFileCountInDirForExtension(f, ext);
            }
        } else if (dir.getName().endsWith(ext.startsWith(".") ? ext : "." + ext)) {
            ++ret;
        }
        return ret;
    }
}

