/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils;

import java.util.Locale;

public class LocaleUtil {
    private static String mapCountry(String country) {
        if ("CHS".equals(country)) {
            return "CN";
        }
        if ("CHT".equals(country)) {
            return "TW";
        }
        return country;
    }

    public static Locale toLocale(String localeString) {
        if (localeString == null || localeString.trim().isEmpty()) {
            return Locale.getDefault();
        }
        String[] parts = localeString.split("-|_", 3);
        int l = parts.length;
        if (l >= 2) {
            parts[1] = LocaleUtil.mapCountry(parts[1]);
            if (l == 2) {
                return new Locale(parts[0], parts[1]);
            }
            return new Locale(parts[0], parts[1], parts[2]);
        }
        return new Locale(parts[0]);
    }

    public static String toString(Locale locale) {
        String localeString = locale.getLanguage();
        String country = locale.getCountry();
        if (!country.isEmpty()) {
            localeString = localeString + '-' + country;
        }
        return localeString;
    }
}

