/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.xml;

import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.StringUtil;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DocumentFragment;

public class StAXWriter
implements Closeable {
    private XMLEventFactory m_factory = XMLEventFactory.newInstance();
    private OutputStream m_out;
    private XMLEventWriter m_xml;
    private Deque<String> m_stack = new ArrayDeque<String>();

    public StAXWriter(OutputStream stream) throws XMLStreamException {
        this.m_out = new BufferedOutputStream(stream);
        this.m_xml = XMLOutputFactory.newInstance().createXMLEventWriter(this.m_out, "UTF-8");
        this.m_xml.add(this.m_factory.createStartDocument("UTF-8"));
    }

    public StAXWriter(File file) throws IOException, XMLStreamException {
        this(new FileOutputStream(file));
    }

    public void setAttribute(String name, String value) throws XMLStreamException {
        this.m_xml.add(this.m_factory.createAttribute(name, value));
    }

    public String getCurrentElement() {
        return this.m_stack.getFirst();
    }

    public void appendFragment(DocumentFragment fragment) throws XMLStreamException {
        if (fragment == null) {
            return;
        }
        this.m_xml.add(this.m_factory.createIgnorableSpace(" "));
        this.m_xml.flush();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(fragment), new StreamResult(this.m_out));
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendFragment(XMLEventReader reader, boolean doUnescape) throws XMLStreamException {
        try {
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isStartDocument() || event.isEndDocument()) continue;
                if (doUnescape && event.isCharacters()) {
                    String str = event.asCharacters().getData();
                    event = this.m_factory.createCharacters(StringUtil.unescapeUnicode(str));
                }
                this.m_xml.add(event);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (XMLStreamException xMLStreamException) {}
        }
    }

    public void appendFragment(InputStream input, boolean doUnescape) throws XMLStreamException {
        if (input != null) {
            this.appendFragment(XMLInputFactory.newInstance().createXMLEventReader(input), doUnescape);
        }
    }

    public void appendFragment(InputStream input) throws XMLStreamException {
        this.appendFragment(input, false);
    }

    public void appendFragment(String xml) throws XMLStreamException {
        if (xml != null) {
            this.appendFragment(XMLInputFactory.newInstance().createXMLEventReader(new StringReader(xml)), false);
        }
    }

    public void insertComment(String comment) throws XMLStreamException {
        this.m_xml.add(this.m_factory.createComment(" " + comment + " "));
    }

    public void beginElement(String name) throws XMLStreamException {
        this.m_xml.add(this.m_factory.createStartElement("", null, name));
        this.m_stack.push(name);
    }

    public void endElement() throws XMLStreamException {
        this.m_xml.add(this.m_factory.createEndElement("", null, this.m_stack.pop()));
    }

    public void endElement(String data) throws XMLStreamException {
        this.m_xml.add(this.m_factory.createCharacters(data));
        this.endElement();
    }

    public void flush() throws XMLStreamException {
        this.m_xml.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.m_xml.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        finally {
            IOUtil.close(this.m_out);
        }
    }
}

