/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.common.build;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Messages;
import com.ibm.appscan.common.build.BuilderDefinition;
import com.ibm.appscan.common.build.BuilderType;
import com.ibm.appscan.common.build.IBuildManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.internal.common.build.BuilderReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.ServiceLoader;
import javax.xml.stream.XMLStreamException;

public class BuildManager
implements IBuildManager {
    private Map<String, BuilderType<? extends BuilderDefinition>> m_builderTypes = new Hashtable<String, BuilderType<? extends BuilderDefinition>>();
    private Map<String, BuilderDefinition> m_builders = new Hashtable<String, BuilderDefinition>();

    public BuildManager() {
        for (BuilderType type : ServiceLoader.load(BuilderType.class)) {
            this.m_builderTypes.put(type.getID(), type);
        }
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(File file) {
        if (file == null || file.isDirectory()) {
            return;
        }
        String filename = file.getName();
        if (!filename.toLowerCase().endsWith(".builder")) {
            return;
        }
        Map<String, BuilderDefinition> map = this.m_builders;
        synchronized (map) {
            BuilderReader reader = new BuilderReader(file, this);
            try {
                reader.read();
                BuilderDefinition builder = reader.getBuilder();
                if (builder != null) {
                    this.m_builders.put(builder.getName(), builder);
                    return;
                }
            }
            catch (FileNotFoundException e) {
                CommonCore.getLogManager().log(new Message(e));
            }
            catch (XMLStreamException e) {
                CommonCore.getLogManager().log(new Message(e));
            }
            CommonCore.getLogManager().log(new Message(2, Messages.getMessage("err.builder", filename)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        Map<String, BuilderDefinition> map = this.m_builders;
        synchronized (map) {
            this.m_builders.clear();
            File config = new File(CommonCore.getDirectoryLocator().getConfig(), "builders");
            File[] files = config.listFiles();
            if (files != null) {
                for (File file : files) {
                    this.load(file);
                }
            }
        }
    }

    @Override
    public boolean register(String name, BuilderDefinition builder, Map<String, String> properties) {
        if (builder.init(name, properties)) {
            this.m_builders.put(name, builder);
            return true;
        }
        return false;
    }

    @Override
    public Collection<BuilderDefinition> getBuilders() {
        return Collections.unmodifiableCollection(this.m_builders.values());
    }

    @Override
    public boolean hasBuilder(String name) {
        return this.m_builders.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuilderDefinition getBuilder(String name) {
        Map<String, BuilderDefinition> map = this.m_builders;
        synchronized (map) {
            if (!this.m_builders.containsKey(name)) {
                for (BuilderType<? extends BuilderDefinition> type : this.m_builderTypes.values()) {
                    BuilderDefinition def = type.autoCreate(name);
                    if (def == null) continue;
                    return def;
                }
            }
            return this.m_builders.get(name);
        }
    }

    @Override
    public Collection<BuilderType<? extends BuilderDefinition>> getBuilderTypes() {
        return Collections.unmodifiableCollection(this.m_builderTypes.values());
    }

    @Override
    public boolean hasBuilderType(String id) {
        return this.m_builderTypes.containsKey(id);
    }

    @Override
    public BuilderType<? extends BuilderDefinition> getBuilderType(String id) {
        return this.m_builderTypes.get(id);
    }
}

