/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.callgraph;

import com.ibm.wala.automaton.DMap;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.ssa.Value;
import com.ibm.wala.util.collections.Filter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class InterReachingDefs {
    private final Map<LocalPointerKey, Collection<LocalPointerKey>> M = new DMap<LocalPointerKey, Collection<LocalPointerKey>>(){

        protected Collection<LocalPointerKey> create(LocalPointerKey key) {
            return new HashSet<LocalPointerKey>();
        }
    };
    private final CallGraph cg;
    private Filter<SSAInstruction> filter;
    private static final Filter<SSAInstruction> defaultFilter = new Filter<SSAInstruction>(){

        public boolean accepts(SSAInstruction o) {
            return false;
        }
    };

    public InterReachingDefs(CallGraph cg) {
        this.cg = cg;
        this.filter = defaultFilter;
    }

    public Filter<SSAInstruction> getFilter() {
        return this.filter;
    }

    public void setFilter(Filter<SSAInstruction> filter) {
        this.filter = filter;
    }

    public CallGraph getCallGraph() {
        return this.cg;
    }

    protected Collection<LocalPointerKey> getDefs(LocalPointerKey pkey) {
        if (this.M.containsKey(pkey)) {
            return this.M.get(pkey);
        }
        Collection<LocalPointerKey> result = this.M.get(pkey);
        CGNode node = pkey.getNode();
        int vn = pkey.getValueNumber();
        SymbolTable tbl = node.getIR().getSymbolTable();
        Value val = tbl.getValue(vn);
        if (val instanceof ConstantValue) {
            result.add(pkey);
            return result;
        }
        this.collectCalleeDefs(pkey, node, vn, result);
        this.collectDefs(pkey, result, node, vn);
        return result;
    }

    private void collectDefs(LocalPointerKey pkey, Collection<LocalPointerKey> result, CGNode node, int vn) {
        DefUse du = node.getDU();
        SSAInstruction instruction = du.getDef(vn);
        if (instruction != null) {
            if (instruction instanceof SSAPhiInstruction || instruction instanceof SSACheckCastInstruction || this.filter.accepts((Object)instruction)) {
                int n = instruction.getNumberOfUses();
                for (int i = 0; i < n; ++i) {
                    int use = instruction.getUse(i);
                    Collection<LocalPointerKey> predResult = this.getDefs(node, use);
                    if (predResult == null) continue;
                    result.addAll(predResult);
                }
            } else {
                result.add(pkey);
            }
        }
    }

    private void collectCalleeDefs(LocalPointerKey pkey, CGNode node, int vn, Collection<LocalPointerKey> result) {
        int[] params = node.getIR().getParameterValueNumbers();
        int paramN = -1;
        for (int i = 0; i < params.length; ++i) {
            if (params[i] != vn) continue;
            paramN = i;
            break;
        }
        if (paramN >= 0) {
            int predCount = this.cg.getPredNodeCount((Object)node);
            if (predCount == 0) {
                result.add(pkey);
            } else {
                Iterator i = this.cg.getPredNodes((Object)node);
                while (i.hasNext()) {
                    CGNode pred = (CGNode)i.next();
                    Iterator j = this.cg.getPossibleSites(pred, node);
                    while (j.hasNext()) {
                        CallSiteReference site = (CallSiteReference)j.next();
                        SSAAbstractInvokeInstruction[] calls = pred.getIR().getCalls(site);
                        if (calls == null) continue;
                        for (SSAAbstractInvokeInstruction call : calls) {
                            int predvn = call.getUse(paramN);
                            Collection<LocalPointerKey> predResult = this.getDefs(pred, predvn);
                            if (predResult == null) continue;
                            result.addAll(predResult);
                        }
                    }
                }
            }
        }
    }

    public Collection<LocalPointerKey> getDefs(CGNode node, int vn) {
        return this.getDefs(new LocalPointerKey(node, vn));
    }
}

