/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.client;

import com.ibm.wala.automaton.grammar.string.ISimplify;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.string.FreshVariableFactory;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.SimpleVariableFactory;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.stringAnalysis.client.IGrammarBasedStringAnalyzer;
import com.ibm.wala.stringAnalysis.grammar.GR;
import com.ibm.wala.stringAnalysis.translator.BB2GR;
import com.ibm.wala.stringAnalysis.translator.BasicSymbolFactory;
import com.ibm.wala.stringAnalysis.translator.IBB2Grammar;
import com.ibm.wala.stringAnalysis.translator.ICG2Grammar;
import com.ibm.wala.stringAnalysis.translator.IConstraintSolver;
import com.ibm.wala.stringAnalysis.translator.IIR2Grammar;
import com.ibm.wala.stringAnalysis.translator.IR2Grammar;
import com.ibm.wala.stringAnalysis.translator.IRuleModifier;
import com.ibm.wala.stringAnalysis.translator.ISSA2Rule;
import com.ibm.wala.stringAnalysis.translator.ISolverCache;
import com.ibm.wala.stringAnalysis.translator.ISolverStack;
import com.ibm.wala.stringAnalysis.translator.ISymbolFactory;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.SimpleSolverCache;
import com.ibm.wala.stringAnalysis.translator.SimpleSolverStack;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.MonitorUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class GrammarBasedStringAnalyzer<T>
implements IGrammarBasedStringAnalyzer<T> {
    private ISimplify grammar;
    private IConstraintSolver<T> solver;
    private CallGraph cg;
    private PointerAnalysis pa;
    private Collection<IRuleModifier> appenders;
    private final ITranslatorRepository<T> repository;
    private final ISymbolFactory<T> symbolFactory;
    private final IVariableFactory<IVariable> varFactory;
    private final ISolverCache<T> cache;
    private final ISolverStack stack;
    private Collection<? extends IVariable> undefinedVariables;
    protected final MonitorUtil.IProgressMonitor monitor;
    protected final Logger logger;
    private final long totalEncodingTime;

    public GrammarBasedStringAnalyzer(CallGraph cg, PointerAnalysis pa, IClassHierarchy cha, MonitorUtil.IProgressMonitor monitor, Logger logger) {
        this.cg = cg;
        this.pa = pa;
        this.appenders = new HashSet<IRuleModifier>();
        this.monitor = monitor;
        this.logger = logger;
        this.varFactory = this.createVariableFactory();
        this.repository = this.createTranslatorRepository();
        this.symbolFactory = this.createSymbolFactory(this.repository, this.varFactory);
        ISSA2Rule<T> ssa2rule = this.createSSA2Rule(this.symbolFactory);
        IBB2Grammar<T> bb2gr = this.createBB2GR(ssa2rule);
        IIR2Grammar<T> ir2gr = this.createIR2GR(bb2gr);
        ICG2Grammar<T> cg2gr = this.createCG2GR(ir2gr);
        long t1 = System.currentTimeMillis();
        this.initGR(cg2gr, cg, pa);
        long t2 = System.currentTimeMillis();
        this.totalEncodingTime = t2 - t1;
        this.cache = this.createSolverCache(this.varFactory);
        this.stack = this.createSolverStack();
        this.solver = this.createSolver(this.repository, this.cache, this.stack, this.varFactory);
    }

    public long getTotalEncodingTime() {
        return this.totalEncodingTime;
    }

    protected void initGR(ICG2Grammar<T> cg2gr, CallGraph cg, PointerAnalysis pa) {
        ISimplify g;
        this.grammar = g = cg2gr.translate(cg, pa);
    }

    @Override
    public ITranslatorRepository<T> getRepository() {
        return this.repository;
    }

    @Override
    public ISymbolFactory<T> getSymbolFactory() {
        return this.symbolFactory;
    }

    @Override
    public IVariableFactory<IVariable> getVariableFactory() {
        return this.varFactory;
    }

    @Override
    public CallGraph getCallGraph() {
        return this.cg;
    }

    @Override
    public PointerAnalysis getPointerAnalysis() {
        return this.pa;
    }

    @Override
    public GR getGR() {
        return (GR)this.grammar;
    }

    public void setUndefinedVariable(Collection<? extends IVariable> vars) {
        this.undefinedVariables = vars;
    }

    @Override
    public IConstraintSolver<T> getSolver() {
        return this.solver;
    }

    @Override
    public ISolverCache<T> getSolverCache() {
        return this.cache;
    }

    protected ISimplify getGrammar(ISimplify g) {
        for (IRuleModifier appender : this.appenders) {
            g = appender.update(g);
        }
        return g;
    }

    protected ISimplify simplify(GR gr) {
        return gr.toSimple();
    }

    @Override
    public void addRuleModifier(IRuleModifier appender) {
        this.appenders.add(appender);
    }

    @Override
    public Map<IVariable, T> infer(Collection<? extends IVariable> vars) {
        ISimplify g = this.getGrammar(this.simplify((GR)this.grammar));
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)"-- target grammar: ");
            SAUtil.println((Object)g);
        }
        SimpleGrammar sg = g.toSimple();
        HashSet removed = new HashSet();
        if (this.undefinedVariables != null) {
            sg = sg.dup();
            for (IVariable iVariable : this.undefinedVariables) {
                removed.addAll(sg.getRules(iVariable));
            }
            sg.getRules().removeAll(removed);
        }
        Map<IVariable, T> results = this.solveConstraint(sg, vars);
        if (SAUtil.DEBUG) {
            for (Map.Entry<IVariable, T> e : results.entrySet()) {
                SAUtil.println((Object)("-- result for " + e.getKey() + ": "));
                SAUtil.println(e.getValue());
            }
        }
        return results;
    }

    protected Map<IVariable, T> solveConstraint(SimpleGrammar sg, Collection<? extends IVariable> vars) {
        Map<IVariable, T> results = this.solver.solve(sg, vars);
        return results;
    }

    protected IBB2Grammar<T> createBB2GR(ISSA2Rule<T> ssa2rule) {
        return new BB2GR<T>(ssa2rule);
    }

    protected IIR2Grammar<T> createIR2GR(IBB2Grammar<T> bb2gr) {
        return new IR2Grammar<T>(bb2gr);
    }

    protected IVariableFactory<IVariable> createVariableFactory() {
        return new FreshVariableFactory((com.ibm.wala.automaton.string.ISymbolFactory)SimpleVariableFactory.defaultFactory);
    }

    protected ISymbolFactory<T> createSymbolFactory(ITranslatorRepository<T> repository, IVariableFactory<IVariable> varFactory) {
        return new BasicSymbolFactory<T>(repository, varFactory);
    }

    protected ISolverCache<T> createSolverCache(IVariableFactory<IVariable> varFactory) {
        SimpleSolverCache cache = new SimpleSolverCache(varFactory);
        return cache;
    }

    protected ISolverStack createSolverStack() {
        SimpleSolverStack stack = new SimpleSolverStack();
        return stack;
    }

    protected abstract IConstraintSolver<T> createSolver(ITranslatorRepository<T> var1, ISolverCache<T> var2, ISolverStack var3, IVariableFactory<IVariable> var4);

    protected abstract ITranslatorRepository<T> createTranslatorRepository();

    protected abstract ISSA2Rule<T> createSSA2Rule(ISymbolFactory<T> var1);

    protected abstract ICG2Grammar<T> createCG2GR(IIR2Grammar<T> var1);
}

