/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.condition.dnf;

import com.ibm.wala.stringAnalysis.condition.IPathCondition;
import com.ibm.wala.stringAnalysis.condition.IPrimitiveCondition;
import com.ibm.wala.stringAnalysis.condition.PathCondition;
import com.ibm.wala.stringAnalysis.condition.dnf.Conjuction;
import com.ibm.wala.stringAnalysis.condition.dnf.DnfMinimizer;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;

public class Dnf {
    private static final boolean DEBUG = false;
    private final Conjuction[] conjunctions;

    public static Dnf make(Conjuction[] conjunctions, DnfMinimizer minimizer) {
        Dnf ret = new Dnf(conjunctions);
        Dnf minimize = minimizer.minimize(ret);
        return minimize;
    }

    Dnf(Conjuction[] disjunctions) {
        Arrays.sort(disjunctions, new Comparator<Conjuction>(){

            @Override
            public int compare(Conjuction o1, Conjuction o2) {
                String o1Str = o1.toString();
                String o2Str = o2.toString();
                int ret = o1Str.length() - o2Str.length();
                if (ret == 0) {
                    ret = o1Str.compareTo(o2Str);
                }
                return ret;
            }
        });
        this.conjunctions = disjunctions;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        boolean first = true;
        for (int i = 0; i < this.conjunctions.length; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(" or ");
            }
            sb.append(this.conjunctions[i]);
        }
        sb.append("}");
        return sb.toString();
    }

    public IPathCondition toPathCondition() {
        HashSet conjuntiveConditions = HashSetFactory.make();
        for (Conjuction c : this.conjunctions) {
            conjuntiveConditions.add(c.toConjunctiveCondition());
        }
        PathCondition ret = new PathCondition(conjuntiveConditions);
        return ret;
    }

    public Dnf or(Dnf other, DnfMinimizer minimizer) {
        if (other.isFalse()) {
            return this;
        }
        if (this.isFalse()) {
            return other;
        }
        if (other.isTrue()) {
            return other;
        }
        if (this.isTrue()) {
            return this;
        }
        Conjuction[] allDisjunctions = new Conjuction[this.conjunctions.length + other.conjunctions.length];
        System.arraycopy(this.conjunctions, 0, allDisjunctions, 0, this.conjunctions.length);
        System.arraycopy(other.conjunctions, 0, allDisjunctions, this.conjunctions.length, other.conjunctions.length);
        Dnf ret = Dnf.make(allDisjunctions, minimizer);
        return ret;
    }

    private boolean isFalse() {
        return this.conjunctions.length == 0;
    }

    public boolean isTrue() {
        return this.conjunctions.length == 1 && this.conjunctions[0].isTrue();
    }

    public Dnf and(Conjuction conjuction, DnfMinimizer minimizer) {
        Conjuction[] nonContrudictingDisjunctions;
        Conjuction[] newConjunctions = new Conjuction[this.conjunctions.length];
        int n = 0;
        for (int i = 0; i < this.conjunctions.length; ++i) {
            Conjuction newConjunction = this.conjunctions[i].and(conjuction);
            if (newConjunction == null) continue;
            newConjunctions[n++] = newConjunction;
        }
        if (n == this.conjunctions.length) {
            nonContrudictingDisjunctions = newConjunctions;
        } else {
            nonContrudictingDisjunctions = new Conjuction[n];
            System.arraycopy(newConjunctions, 0, nonContrudictingDisjunctions, 0, n);
        }
        Dnf ret = Dnf.make(nonContrudictingDisjunctions, minimizer);
        return ret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.conjunctions);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dnf other = (Dnf)obj;
        return Arrays.equals(this.conjunctions, other.conjunctions);
    }

    public Collection<IPrimitiveCondition> getAllPrimitiveConditions() {
        ArrayList<IPrimitiveCondition> ret = new ArrayList<IPrimitiveCondition>();
        for (Conjuction c : this.conjunctions) {
            ret.addAll(c.getAllPrimitiveConditions());
        }
        return ret;
    }

    public int getNumberOfDisjunctions() {
        return this.conjunctions.length;
    }

    public Conjuction[] getDisjunctions() {
        return this.conjunctions;
    }
}

