/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.condition.dnf;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;

class Term {
    public static final byte DontCare = 2;
    private byte[] varVals;

    public Term(byte[] varVals) {
        this.varVals = varVals;
    }

    public int getNumVars() {
        return this.varVals.length;
    }

    public byte[] getVals() {
        return this.varVals;
    }

    public String toString() {
        String result = "{";
        for (int i = 0; i < this.varVals.length; ++i) {
            result = this.varVals[i] == 2 ? result + "X" : result + this.varVals[i];
            result = result + " ";
        }
        result = result + "}";
        return result;
    }

    public Term combine(Term term) {
        int diffVarNum = -1;
        for (int i = 0; i < this.varVals.length; ++i) {
            if (this.varVals[i] == term.varVals[i]) continue;
            if (diffVarNum == -1) {
                diffVarNum = i;
                continue;
            }
            return null;
        }
        if (diffVarNum == -1) {
            return null;
        }
        byte[] resultVars = (byte[])this.varVals.clone();
        resultVars[diffVarNum] = 2;
        return new Term(resultVars);
    }

    public int countValues(byte value) {
        int result = 0;
        for (int i = 0; i < this.varVals.length; ++i) {
            if (this.varVals[i] != value) continue;
            ++result;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        Term rhs = (Term)o;
        return Arrays.equals(this.varVals, rhs.varVals);
    }

    public int hashCode() {
        return this.varVals.hashCode();
    }

    boolean implies(Term term) {
        for (int i = 0; i < this.varVals.length; ++i) {
            if (this.varVals[i] == 2 || this.varVals[i] == term.varVals[i]) continue;
            return false;
        }
        return true;
    }

    public static Term read(Reader reader) throws IOException {
        int c = 0;
        ArrayList<Byte> t = new ArrayList<Byte>();
        while (c != 10 && c != -1) {
            c = reader.read();
            if (c == 48) {
                t.add((byte)0);
                continue;
            }
            if (c != 49) continue;
            t.add((byte)1);
        }
        if (t.size() > 0) {
            byte[] resultBytes = new byte[t.size()];
            for (int i = 0; i < t.size(); ++i) {
                resultBytes[i] = (Byte)t.get(i);
            }
            return new Term(resultBytes);
        }
        return null;
    }
}

