/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator;

import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.stringAnalysis.grammar.GR;
import com.ibm.wala.stringAnalysis.ssa.IRRewriter;
import com.ibm.wala.stringAnalysis.translator.IBB2Grammar;
import com.ibm.wala.stringAnalysis.translator.IIR2Grammar;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import com.ibm.wala.types.MethodReference;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class IR2SyntheticIR<T>
implements IIR2Grammar<T> {
    private static final int CACHE_SIZE = 100;
    private IIR2Grammar<T> base;
    LinkedHashMap<IR, IR> irMap = new LinkedHashMap<IR, IR>(16, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<IR, IR> eldest) {
            if (this.size() >= 100) {
                return true;
            }
            return super.removeEldestEntry(eldest);
        }
    };
    LinkedHashMap<IR, IRRewriter.Conversion> convMap = new LinkedHashMap<IR, IRRewriter.Conversion>(16, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<IR, IRRewriter.Conversion> eldest) {
            if (this.size() >= 100) {
                return true;
            }
            return super.removeEldestEntry(eldest);
        }
    };

    public IR2SyntheticIR(IIR2Grammar<T> ir2gr) {
        this.base = ir2gr;
    }

    @Override
    public IBB2Grammar<T> getBB2Grammar() {
        return this.base.getBB2Grammar();
    }

    protected abstract boolean isTarget(MethodReference var1);

    @Override
    public GR translate(TranslationContext ctx) {
        return this.translateSyntheticIR(ctx);
    }

    private TranslationContext makeTranslationContext(IR ir, TranslationContext ctx) {
        TranslationContext ctx2 = new TranslationContext(ir, ctx.getCGNode(), ctx.getCallGraph(), ctx.getPointerAnalysis(), ctx.getTypeInference(), ctx.getPathConditionAnalysis(), ctx.getProgressMonitor(), ctx.getLogger());
        return ctx2;
    }

    private GR translateSyntheticIR(final TranslationContext ctx) {
        IR ir;
        if (this.irMap.containsKey(ctx.getIR())) {
            ir = this.irMap.get(ctx.getIR());
        } else {
            IRRewriter r = new IRRewriter(ctx.getInstructionFactory());
            ir = r.copyAndRewrite(ctx.getIR(), ctx.getCGNode().getContext(), ctx.getLogger(), new IRRewriter.ISSAInstructionRewriteRule(){

                private int[] getUses(SSAInstruction instruction) {
                    int n = instruction.getNumberOfUses();
                    int[] use = new int[n];
                    for (int i = 0; i < n; ++i) {
                        use[i] = instruction.getUse(i);
                    }
                    return use;
                }

                private boolean isUsed(int def) {
                    return ctx.getDefUse().getUses(def).hasNext();
                }

                @Override
                public SSAInstruction rewrite(SSAInstructionFactory factory, SSAInstruction instruction) {
                    SSAInvokeInstruction invoke;
                    MethodReference mref;
                    if (instruction instanceof SSAInvokeInstruction && IR2SyntheticIR.this.isTarget(mref = (invoke = (SSAInvokeInstruction)instruction).getDeclaredTarget()) && !this.isUsed(invoke.getDef())) {
                        return invoke.copyForSSA(factory, new int[]{invoke.getReceiver(), invoke.getException()}, this.getUses(instruction));
                    }
                    return instruction;
                }

                @Override
                public boolean matches(SSAInstruction instruction) {
                    return true;
                }
            });
            this.irMap.put(ctx.getIR(), ir);
        }
        return this.base.translate(this.makeTranslationContext(ir, ctx));
    }

    private GR translateIR(final TranslationContext ctx) {
        if (this.convMap.containsKey(ctx.getIR())) {
            IRRewriter.Conversion conv = this.convMap.get(ctx.getIR());
            if (conv == null) {
                return this.base.translate(ctx);
            }
            conv.redo();
            GR gr = this.base.translate(ctx);
            conv.undo();
            return gr;
        }
        IR ir = ctx.getIR();
        IRRewriter r = new IRRewriter(ctx.getInstructionFactory());
        IRRewriter.Conversion conv = r.rewrite(ir, ctx.getCGNode().getContext(), new IRRewriter.ISSAInstructionRewriteRule(){

            private int[] getUses(SSAInstruction instruction) {
                int n = instruction.getNumberOfUses();
                int[] use = new int[n];
                for (int i = 0; i < n; ++i) {
                    use[i] = instruction.getUse(i);
                }
                return use;
            }

            private boolean isUsed(int def) {
                return ctx.getDefUse().getUses(def).hasNext();
            }

            @Override
            public SSAInstruction rewrite(SSAInstructionFactory factory, SSAInstruction instruction) {
                SSAInvokeInstruction invoke;
                MethodReference mref;
                if (instruction instanceof SSAInvokeInstruction && IR2SyntheticIR.this.isTarget(mref = (invoke = (SSAInvokeInstruction)instruction).getDeclaredTarget()) && !this.isUsed(invoke.getDef())) {
                    return invoke.copyForSSA(factory, new int[]{invoke.getReceiver(), invoke.getException()}, this.getUses(instruction));
                }
                return instruction;
            }

            @Override
            public boolean matches(SSAInstruction instruction) {
                return true;
            }
        });
        this.convMap.put(ir, conv);
        GR gr = this.base.translate(ctx);
        conv.undo();
        return gr;
    }
}

