/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator;

import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.stringAnalysis.grammar.InstanceKeyVariable;
import com.ibm.wala.stringAnalysis.translator.BasicSymbolFactory;
import com.ibm.wala.stringAnalysis.translator.ISymbolFactory;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collection;
import java.util.HashSet;

public class InstanceBasedSymbolFactory<T>
extends BasicSymbolFactory<T> {
    private final ISymbolFactory<T> base;
    private final Filter<InstanceKey> mutableObjectFilter;

    public InstanceBasedSymbolFactory(ISymbolFactory<T> base, Filter<InstanceKey> mutableObjectFilter) {
        super(base.getRepository(), base.getVariableFactory());
        this.base = base;
        this.mutableObjectFilter = mutableObjectFilter;
    }

    @Override
    public Collection<ISymbol> createInstanceKeySymbol(int v, TranslationContext ctx) throws ISymbolFactory.NoInstanceKeyException {
        PointerKey pkey = null;
        if (ctx.getCGNode() != null) {
            pkey = ctx.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(ctx.getCGNode(), v);
        }
        HashSet<ISymbol> syms = new HashSet<ISymbol>();
        if (pkey == null) {
            return this.base.createInstanceKeySymbol(v, ctx);
        }
        OrdinalSet ikeys = ctx.getPointerAnalysis().getPointsToSet(pkey);
        if (ikeys.isEmpty()) {
            return this.base.createInstanceKeySymbol(v, ctx);
        }
        for (InstanceKey ikey : ikeys) {
            Collection<ISymbol> isyms = this.getInstanceKeySymbol(ikey, ctx);
            if (isyms.isEmpty()) {
                return this.base.createInstanceKeySymbol(v, ctx);
            }
            syms.addAll(isyms);
        }
        return syms;
    }

    @Override
    public Collection<IVariable> createCDVariable(int v, TranslationContext ctx) {
        PointerAnalysis pa;
        HeapModel h;
        PointerKey pkey;
        HashSet<IVariable> result = new HashSet<IVariable>();
        if (v > 0 && (pkey = (h = (pa = ctx.getPointerAnalysis()).getHeapModel()).getPointerKeyForLocal(ctx.getCGNode(), v)) != null) {
            OrdinalSet ikeys = pa.getPointsToSet(pkey);
            for (InstanceKey ikey : ikeys) {
                if (!this.mutableObjectFilter.accepts((Object)ikey)) continue;
                result.add((IVariable)new InstanceKeyVariable(ikey));
            }
        }
        if (result.isEmpty()) {
            result.addAll(this.base.createCDVariable(v, ctx));
        }
        return result;
    }
}

