/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.cfg;

import com.ibm.wala.automaton.grammar.string.DeepGrammarCopier;
import com.ibm.wala.automaton.grammar.string.DeepRuleCopier;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammarCopier;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.IRuleCopier;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.string.ILabelSymbol;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.LabelSubstitution;
import com.ibm.wala.automaton.string.Labeling;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.SetSymbol;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.stringAnalysis.grammar.InvocationSymbol;
import com.ibm.wala.stringAnalysis.translator.ISolverCache;
import com.ibm.wala.stringAnalysis.translator.ISolverStack;
import com.ibm.wala.stringAnalysis.translator.ITranslator;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.LabeledSymbolFactory;
import com.ibm.wala.stringAnalysis.translator.TranslationException;
import com.ibm.wala.stringAnalysis.translator.cfg.CFGConstraintSolver;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.MonitorUtil;
import java.util.Collection;
import java.util.HashMap;

public class LabeledCFGConstraintSolver
extends CFGConstraintSolver {
    private final ILabelSymbol defaultLabel;
    private static final boolean labelSensitiveRewriting = Boolean.getBoolean("com.ibm.wala.stringAnalysis.labelSensitiveRewriting");

    public LabeledCFGConstraintSolver(ITranslatorRepository<IContextFreeGrammar> repository, ILabelSymbol defaultLabel, ISolverCache<IContextFreeGrammar> cache, ISolverStack stack, MonitorUtil.IProgressMonitor monitor) {
        super(repository, cache, stack, monitor);
        assert (defaultLabel != null);
        this.defaultLabel = defaultLabel;
    }

    @Override
    protected <T extends IGrammar> T substituteGrammars(T g) {
        return (T)new LabelSubstitutionForSolver().substitute(g, null);
    }

    @Override
    protected IContextFreeGrammar substitute(IContextFreeGrammar g) {
        return (IContextFreeGrammar)new LabelSubstitutionForSolver().substitute((IGrammar)g, null);
    }

    @Override
    protected void addAnyRule(SimpleGrammar cfg, Collection<IVariable> dvars) {
        IVariable v = this.varFactory.createVariable("ANY");
        cfg.addRule((IProductionRule)new ProductionRule(v, new ISymbol[]{new RangeSymbol('\u0000', '\uffff').copy((ISymbolCopier)new Labeling(this.defaultLabel)), v}));
        cfg.addRule((IProductionRule)new ProductionRule(v, new ISymbol[0]));
        for (IVariable dvar : dvars) {
            ProductionRule rule = new ProductionRule(dvar, (ISymbol)v);
            cfg.addRule((IProductionRule)rule);
            if (!SAUtil.DEBUG) continue;
            SAUtil.println((Object)("added the rule: " + rule));
        }
    }

    @Override
    protected SimpleGrammar rewrite(String signature, InvocationSymbol f, ITranslator<IContextFreeGrammar> translator, IProductionRule r, SimpleGrammar tg) {
        tg = translator.prepare(this, signature, f.getReceiver(), f.getParameters(), r, tg);
        return this.propagateLabels(tg, f);
    }

    @Override
    protected IContextFreeGrammar translate(ITranslator<IContextFreeGrammar> translator, IProductionRule invokeRule, IContextFreeGrammar target, int cyclic) {
        IContextFreeGrammar translatedGrammar = null;
        try {
            translatedGrammar = cyclic > 0 ? translator.translateCyclic(target, cyclic) : translator.translate(target);
        }
        catch (TranslationException e) {
            translatedGrammar = translator.possibleGrammar(target);
        }
        InvocationSymbol invoke = (InvocationSymbol)invokeRule.getRight(0);
        return this.propagateLabels(translatedGrammar, invoke);
    }

    private <T extends IGrammar> T propagateLabels(T translatedGrammar, InvocationSymbol invoke) {
        SSAInstruction instruction = invoke.getInstruction();
        int vn = -1;
        if (instruction != null) {
            if (instruction instanceof SSAAbstractInvokeInstruction) {
                SSAAbstractInvokeInstruction invokeInstruction = (SSAAbstractInvokeInstruction)instruction;
                if (invokeInstruction.getNumberOfReturnValues() > 0) {
                    vn = instruction.getDef();
                }
            } else if (instruction.getNumberOfDefs() > 0) {
                vn = instruction.getDef();
            }
        }
        if (vn >= 0) {
            SetSymbol invokeLabel = new SetSymbol((Object)new LabeledSymbolFactory.LabelElement(invoke.getCallGraph(), invoke.getCGNode(), instruction, vn));
            translatedGrammar = translatedGrammar.copy((IGrammarCopier)new DeepGrammarCopier((IRuleCopier)new DeepRuleCopier((ISymbolCopier)new Labeling((ILabelSymbol)invokeLabel))));
            if (labelSensitiveRewriting) {
                translatedGrammar = Grammars.useUniqueVariables(translatedGrammar, (IVariableFactory)this.varFactory, new HashMap());
            }
        }
        return translatedGrammar;
    }

    public static class LabelSubstitutionForSolver
    extends LabelSubstitution {
        public ISymbol copy(ISymbol s) {
            if (s instanceof InvocationSymbol) {
                return s;
            }
            return super.copy(s);
        }
    }
}

