/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.concurrent;

import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.stringAnalysis.client.CFGStringVerifier;
import com.ibm.wala.stringAnalysis.client.IGrammarBasedStringAnalyzer;
import com.ibm.wala.stringAnalysis.client.IStringAnalyzer;
import com.ibm.wala.stringAnalysis.client.IStringVerifier;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.Pair;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ConcurrentStringVerifier
extends CFGStringVerifier {
    private final Server[] servers;

    @Override
    public synchronized IAutomaton compilePattern(String patStr) {
        return super.compilePattern(patStr);
    }

    public ConcurrentStringVerifier(IGrammarBasedStringAnalyzer<IContextFreeGrammar> analyzer, int nThread, MonitorUtil.IProgressMonitor monitor) {
        super((IStringAnalyzer<IContextFreeGrammar, IVariable>)analyzer, monitor);
        this.servers = new Server[nThread];
    }

    @Override
    protected Map<IStringVerifier.IRule<IVariable>, IStringVerifier.IResult<IContextFreeGrammar, IVariable>> verifyInternal(Map<IVariable, IStringVerifier.IRule<IVariable>> ruleMap, Map<IVariable, IContextFreeGrammar> cfgs) {
        int i;
        ConcurrentHashMap<IStringVerifier.IRule<IVariable>, IStringVerifier.IResult<IContextFreeGrammar, IVariable>> results = new ConcurrentHashMap<IStringVerifier.IRule<IVariable>, IStringVerifier.IResult<IContextFreeGrammar, IVariable>>();
        ConcurrentLinkedQueue<Pair<IVariable, IStringVerifier.IRule<IVariable>>> ruleQueue = new ConcurrentLinkedQueue<Pair<IVariable, IStringVerifier.IRule<IVariable>>>();
        ConcurrentHashMap<IVariable, IContextFreeGrammar> ccfgs = new ConcurrentHashMap<IVariable, IContextFreeGrammar>(cfgs);
        for (Map.Entry<IVariable, IStringVerifier.IRule<IVariable>> e : ruleMap.entrySet()) {
            ruleQueue.add(Pair.make((Object)e.getKey(), e.getValue()));
        }
        for (i = 0; i < this.servers.length; ++i) {
            this.servers[i] = new Server(ruleQueue, results, ccfgs, this.monitor);
            this.servers[i].start();
        }
        for (i = 0; i < this.servers.length; ++i) {
            try {
                this.servers[i].join();
                continue;
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
        return results;
    }

    protected class Server
    extends Thread {
        final Queue<Pair<IVariable, IStringVerifier.IRule<IVariable>>> ruleQueue;
        final Map<IVariable, IContextFreeGrammar> cfgs;
        final Map<IStringVerifier.IRule<IVariable>, IStringVerifier.IResult<IContextFreeGrammar, IVariable>> results;

        public Server(Queue<Pair<IVariable, IStringVerifier.IRule<IVariable>>> ruleQueue, Map<IStringVerifier.IRule<IVariable>, IStringVerifier.IResult<IContextFreeGrammar, IVariable>> results, Map<IVariable, IContextFreeGrammar> cfgs, MonitorUtil.IProgressMonitor monitor) {
            this.ruleQueue = ruleQueue;
            this.results = results;
            this.cfgs = cfgs;
            this.setUncaughtExceptionHandler(Thread.getDefaultUncaughtExceptionHandler());
        }

        @Override
        public void run() {
            Pair<IVariable, IStringVerifier.IRule<IVariable>> entry = this.ruleQueue.poll();
            while (entry != null) {
                ConcurrentStringVerifier.this.verifyInternal(this.cfgs, this.results, entry.fst, (IStringVerifier.IRule)entry.snd);
                entry = this.ruleQueue.poll();
            }
        }
    }
}

