/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.regular.repository;

import com.ibm.wala.analysis.typeInference.JavaPrimitiveType;
import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.automaton.grammar.string.CFGSymbol;
import com.ibm.wala.automaton.grammar.string.ContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.IllegalGrammarException;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.NumberSymbol;
import com.ibm.wala.automaton.string.State;
import com.ibm.wala.automaton.string.Transition;
import com.ibm.wala.automaton.string.Variable;
import com.ibm.wala.stringAnalysis.translator.TranslationException;
import com.ibm.wala.stringAnalysis.translator.regular.repository.Transducer;
import java.util.HashSet;
import java.util.Set;

public class Insert
extends Transducer {
    private int offsetParamIndex;
    private int insParamIndex;
    private PrimitiveType insType;

    public Insert(int target, int offset, int ins, PrimitiveType insType) {
        super(target);
        this.offsetParamIndex = offset;
        this.insParamIndex = ins;
        this.insType = insType;
    }

    public Insert(int offset, int ins, PrimitiveType insType) {
        this.offsetParamIndex = offset;
        this.insParamIndex = ins;
        this.insType = insType;
    }

    public Insert(PrimitiveType insType) {
        this(0, 1, insType);
    }

    public Insert() {
        this(0, 1, null);
    }

    @Override
    public IAutomaton translate(IAutomaton a) throws TranslationException {
        try {
            ISymbol insSym = this.getInsSymbol();
            int offset = this.solveNumberParameter(this.offsetParamIndex).intValue();
            if (offset == 0) {
                Automaton prefix = Automatons.createAutomaton((ISymbol[])new ISymbol[]{insSym});
                return Automatons.createConcatenation((IAutomaton)prefix, (IAutomaton)a);
            }
        }
        catch (IllegalGrammarException illegalGrammarException) {
            // empty catch block
        }
        return super.translate(a);
    }

    @Override
    public boolean acceptCyclic() {
        return true;
    }

    private ISymbol getInsSymbol() throws IllegalGrammarException {
        CFGSymbol insSym;
        if (this.insType == null) {
            insSym = this.solveStringParameter(this.insParamIndex);
        } else if (this.insType.equals((Object)JavaPrimitiveType.CHAR)) {
            Set<NumberSymbol> nums = this.solveNumberParameters(this.insParamIndex);
            IVariable v = this.createVariable();
            ContextFreeGrammar ng = new ContextFreeGrammar();
            ng.setStartSymbol(v);
            for (NumberSymbol num : nums) {
                ng.addRule((IProductionRule)new ProductionRule(v, (ISymbol)new CharSymbol((char)num.intValue())));
            }
            insSym = new CFGSymbol((IContextFreeGrammar)ng);
        } else {
            insSym = this.solveStringParameter(this.insParamIndex);
        }
        return insSym;
    }

    @Override
    public IAutomaton createTransducer() {
        try {
            State nextState;
            int i;
            State initState;
            Variable v = new Variable("v");
            int offset = this.solveNumberParameter(this.offsetParamIndex).intValue();
            ISymbol insSym = this.getInsSymbol();
            HashSet<Transition> transitions = new HashSet<Transition>();
            State state = initState = new State("s0");
            for (i = 0; i < offset; ++i) {
                nextState = new State("s" + (i + 1));
                Transition t = new Transition((IState)state, (IState)nextState, (ISymbol)v, new ISymbol[]{v});
                transitions.add(t);
                state = nextState;
            }
            nextState = new State("s" + (i + 1));
            ISymbol[] symbols = new ISymbol[]{insSym, v};
            Transition tIns = new Transition((IState)state, (IState)nextState, (ISymbol)v, symbols);
            transitions.add(tIns);
            state = nextState;
            Transition t = new Transition((IState)state, (IState)state, (ISymbol)v, new ISymbol[]{v});
            transitions.add(t);
            HashSet<State> finalStates = new HashSet<State>();
            finalStates.add(state);
            Automaton transducer = new Automaton((IState)initState, finalStates, transitions);
            return transducer;
        }
        catch (IllegalGrammarException e) {
            return null;
        }
    }
}

