/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.regular.repository;

import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.stringAnalysis.condition.CaseCondition;
import com.ibm.wala.stringAnalysis.condition.IPrimitiveCondition;
import com.ibm.wala.stringAnalysis.condition.NotCaseCondition;
import com.ibm.wala.stringAnalysis.condition.RangeCondition;
import com.ibm.wala.stringAnalysis.grammar.ConditionedInvocationSymbol;
import com.ibm.wala.stringAnalysis.translator.IConstraintSolver;
import com.ibm.wala.stringAnalysis.translator.TranslationException;
import com.ibm.wala.stringAnalysis.translator.regular.repository.StringConstraint;
import java.util.List;

public class StringLengthCheck
extends StringConstraint {
    public StringLengthCheck(int target, int constraintTarget) {
        super(target, constraintTarget);
    }

    public StringLengthCheck(int target) {
        this(target, target);
    }

    @Override
    public SimpleGrammar prepare(IConstraintSolver<IAutomaton> solver, String funcName, ISymbol recv, List<ISymbol> params, IProductionRule rule, SimpleGrammar grammar) {
        boolean isEmpty = false;
        if (rule.getRight(0) instanceof ConditionedInvocationSymbol) {
            ConditionedInvocationSymbol invoke = (ConditionedInvocationSymbol)rule.getRight(0);
            IPrimitiveCondition cond = invoke.getCondition();
            if (cond instanceof RangeCondition) {
                RangeCondition range = (RangeCondition)cond;
                switch (range.op) {
                    case LT: {
                        if (range.boundary <= 1L) {
                            isEmpty = true;
                            break;
                        }
                    }
                    case LE: {
                        if (range.boundary >= 1L) break;
                        isEmpty = true;
                    }
                }
            } else if (cond instanceof CaseCondition) {
                CaseCondition c = (CaseCondition)cond;
                if (c.label == 0) {
                    isEmpty = true;
                }
            } else if (cond instanceof NotCaseCondition) {
                // empty if block
            }
        }
        if (isEmpty) {
            return StringLengthCheck.createEmpty();
        }
        return StringLengthCheck.createAny();
    }

    @Override
    public IAutomaton translate(IAutomaton a) throws TranslationException {
        return a;
    }
}

