/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.regular.repository;

import com.ibm.wala.automaton.grammar.string.IllegalGrammarException;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.stringAnalysis.translator.TranslationException;
import com.ibm.wala.stringAnalysis.translator.regular.repository.Homomorphism;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class StringStripByChars
extends Homomorphism {
    private final int charsIndex;

    public StringStripByChars(int target, int charsIndex) {
        super(target);
        this.charsIndex = charsIndex;
    }

    @Override
    protected Set<Homomorphism.Rule> getRuleSet() throws TranslationException {
        try {
            Collection<String> strs = this.solveStringConstantParameters(this.charsIndex);
            HashSet chars = null;
            for (String s : strs) {
                List cs = StringSymbol.toCharSymbols((String)s);
                if (chars == null) {
                    chars = new HashSet(cs);
                    continue;
                }
                chars.retainAll(cs);
            }
            return Collections.singleton(new RemovalRule(chars));
        }
        catch (IllegalGrammarException e) {
            throw new TranslationException(e.getMessage());
        }
    }

    @Override
    protected Collection<ISymbol> getTerminals(Collection<Homomorphism.Rule> ruleSet) {
        HashSet<ISymbol> terminals = new HashSet<ISymbol>();
        for (Homomorphism.Rule r : ruleSet) {
            terminals.addAll(r.getTerminals());
        }
        return terminals;
    }

    private static class RemovalRule
    implements Homomorphism.Rule {
        final Collection<CharSymbol> chars;

        public RemovalRule(Collection<CharSymbol> cs) {
            this.chars = cs;
        }

        public List<ISymbol> invoke(ISymbol symbol, List<ISymbol> outputs) {
            CharSymbol cs;
            if (symbol instanceof CharSymbol && this.chars.contains(cs = (CharSymbol)symbol)) {
                return Arrays.asList(new ISymbol[0]);
            }
            return Arrays.asList(symbol);
        }

        public boolean accept(ISymbol symbol, IMatchContext ctx) {
            return true;
        }

        public Collection<ISymbol> getTerminals() {
            return new HashSet<CharSymbol>(this.chars);
        }
    }
}

