/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.regular.repository;

import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.FilteredTransition;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.State;
import com.ibm.wala.automaton.string.Variable;
import com.ibm.wala.stringAnalysis.translator.regular.repository.Transducer;
import com.ibm.wala.util.debug.Assertions;
import java.util.HashSet;

public class StripCSlashes
extends Transducer {
    private static final CharSymbol SYM_BSLASH = new CharSymbol('\\');
    private static final FilteredTransition.ICondition IS_BSLASH = new FilteredTransition.IObsoleteCondition(){

        public boolean accept(ISymbol symbol, IMatchContext ctx) {
            if (symbol instanceof CharSymbol) {
                char c = ((CharSymbol)symbol).charValue();
                return c == '\\';
            }
            return symbol.equals(SYM_BSLASH);
        }
    };
    private static final FilteredTransition.ICondition NOT_BSLASH = new FilteredTransition.IObsoleteCondition(){

        public boolean accept(ISymbol symbol, IMatchContext ctx) {
            return !IS_BSLASH.accept(symbol, ctx);
        }
    };
    private static final IsChar IS_SMALL_X = new IsChar('x');
    private static final IsChar[] IS_HEX;
    private static final IsChar[] IS_OCTAL;
    private static final FilteredTransition.ICondition NOT_HEX;
    private static final FilteredTransition.ICondition NOT_OCTAL;
    private static final FilteredTransition.ICondition NOT_SPECIAL;

    public StripCSlashes(int target) {
        super(target);
    }

    public StripCSlashes() {
    }

    protected int hexToInt(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        Assertions.UNREACHABLE((String)("Not a hex digit: " + c));
        return Integer.MIN_VALUE;
    }

    @Override
    public IAutomaton createTransducer() {
        char c;
        ITransition[] metaCharTrans;
        State s0;
        Variable v = new Variable("v");
        HashSet<Object> transitions = new HashSet<Object>();
        State initState = s0 = new State("s0");
        HashSet<State> finalStates = new HashSet<State>();
        finalStates.add(s0);
        FilteredTransition t = new FilteredTransition((IState)s0, (IState)s0, (ISymbol)v, new ISymbol[]{v}, null, NOT_BSLASH);
        transitions.add(t);
        State sX = new State("sX");
        t = new FilteredTransition((IState)s0, (IState)sX, (ISymbol)v, new ISymbol[]{v}, null, IS_BSLASH);
        transitions.add(t);
        finalStates.add(sX);
        State s1 = new State("s1");
        t = new FilteredTransition((IState)s0, (IState)s1, (ISymbol)v, new ISymbol[0], null, IS_BSLASH);
        transitions.add(t);
        t = new FilteredTransition((IState)s1, (IState)s0, (ISymbol)v, new ISymbol[]{v}, null, NOT_SPECIAL);
        transitions.add(t);
        for (ITransition tr : metaCharTrans = UnquoteMetaTransition.makeTransitions((IState)s1, (IState)s0, (ISymbol)v)) {
            transitions.add(tr);
        }
        State sx = new State("sx");
        t = new FilteredTransition((IState)s1, (IState)sx, (ISymbol)v, new ISymbol[0], null, (FilteredTransition.ICondition)IS_SMALL_X);
        transitions.add(t);
        for (IsChar cond : IS_HEX) {
            c = cond.c;
            State sxc = new State("sx" + c);
            t = new FilteredTransition((IState)sx, (IState)sxc, (ISymbol)v, new ISymbol[0], null, (FilteredTransition.ICondition)cond);
            transitions.add(t);
            for (IsChar cond2 : IS_HEX) {
                int val = this.hexToInt(c) * 16 + this.hexToInt(cond2.c);
                CharSymbol out = new CharSymbol((char)val);
                t = new FilteredTransition((IState)sxc, (IState)s0, (ISymbol)v, new ISymbol[]{out}, null, (FilteredTransition.ICondition)cond2);
                transitions.add(t);
            }
            int val = this.hexToInt(c);
            CharSymbol hexOut = new CharSymbol((char)val);
            t = new FilteredTransition((IState)sxc, (IState)s0, (ISymbol)v, new ISymbol[]{hexOut, v}, null, NOT_HEX);
            transitions.add(t);
        }
        for (IsChar cond : IS_OCTAL) {
            c = cond.c;
            String nm = "sO" + c;
            State sOc = new State(nm);
            t = new FilteredTransition((IState)s1, (IState)sOc, (ISymbol)v, new ISymbol[0], null, (FilteredTransition.ICondition)cond);
            transitions.add(t);
            for (IsChar cond2 : IS_OCTAL) {
                char c2 = cond2.c;
                State sOc_c2 = new State(nm + c2);
                t = new FilteredTransition((IState)sOc, (IState)sOc_c2, (ISymbol)v, new ISymbol[0], null, (FilteredTransition.ICondition)cond2);
                transitions.add(t);
                for (IsChar cond3 : IS_OCTAL) {
                    char c3 = cond3.c;
                    int val = (c - 48) * 8 * 8 + (c2 - 48) * 8 + (c3 - 48);
                    CharSymbol out = new CharSymbol((char)val);
                    t = new FilteredTransition((IState)sOc_c2, (IState)s0, (ISymbol)v, new ISymbol[]{out}, null, (FilteredTransition.ICondition)cond3);
                    transitions.add(t);
                }
                int val = (c - 48) * 8 + (c2 - 48);
                CharSymbol out = new CharSymbol((char)val);
                t = new FilteredTransition((IState)sOc_c2, (IState)s0, (ISymbol)v, new ISymbol[]{out, v}, null, NOT_OCTAL);
                transitions.add(t);
            }
            int val = c - 48;
            CharSymbol out = new CharSymbol((char)val);
            t = new FilteredTransition((IState)sOc, (IState)s0, (ISymbol)v, new ISymbol[]{out, v}, null, NOT_OCTAL);
            transitions.add(t);
        }
        Automaton transducer = new Automaton((IState)initState, finalStates, transitions);
        return transducer;
    }

    static {
        char[] hex = "0123456789abcdefABCDEF".toCharArray();
        IS_HEX = new IsChar[hex.length];
        int i = 0;
        for (char c : hex) {
            StripCSlashes.IS_HEX[i++] = new IsChar(c);
        }
        IS_OCTAL = new IsChar[8];
        for (i = 0; i < 8; ++i) {
            StripCSlashes.IS_OCTAL[i] = IS_HEX[i];
        }
        NOT_HEX = new FilteredTransition.IObsoleteCondition(){

            public boolean accept(ISymbol symbol, IMatchContext ctx) {
                char d;
                if (symbol instanceof CharSymbol) {
                    d = ((CharSymbol)symbol).charValue();
                } else {
                    String name = symbol.getName();
                    if (name.length() != 1) {
                        return false;
                    }
                    d = name.charAt(0);
                }
                if (d >= '0' && d <= '9') {
                    return false;
                }
                if (d >= 'a' && d <= 'f') {
                    return false;
                }
                return d < 'A' || d > 'F';
            }
        };
        NOT_OCTAL = new FilteredTransition.IObsoleteCondition(){

            public boolean accept(ISymbol symbol, IMatchContext ctx) {
                char d;
                if (symbol instanceof CharSymbol) {
                    d = ((CharSymbol)symbol).charValue();
                } else {
                    String name = symbol.getName();
                    if (name.length() != 1) {
                        return false;
                    }
                    d = name.charAt(0);
                }
                return d < '0' || d > '7';
            }
        };
        NOT_SPECIAL = new FilteredTransition.IObsoleteCondition(){

            public boolean accept(ISymbol symbol, IMatchContext ctx) {
                char d;
                if (symbol instanceof CharSymbol) {
                    d = ((CharSymbol)symbol).charValue();
                } else {
                    String name = symbol.getName();
                    if (name.length() != 1) {
                        return false;
                    }
                    d = name.charAt(0);
                }
                if (d >= '0' && d <= '7') {
                    return false;
                }
                switch (d) {
                    case '\\': 
                    case 'a': 
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': 
                    case 'v': 
                    case 'x': {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    private static class UnquoteMetaTransition
    extends FilteredTransition {
        private UnquoteMetaTransition(IState s0, IState s1, ISymbol in, char c, char out) {
            super(s0, s1, in, (ISymbol[])new CharSymbol[]{new CharSymbol(out)}, null, (FilteredTransition.ICondition)new IsChar(c));
        }

        public static ITransition[] makeTransitions(IState s0, IState s1, ISymbol in) {
            return new ITransition[]{new ALARM(s0, s1, in), new BSLASH(s0, s1, in), new BSPACE(s0, s1, in), new CR(s0, s1, in), new FORMFEED(s0, s1, in), new LF(s0, s1, in), new TAB(s0, s1, in), new VTAB(s0, s1, in)};
        }

        private static class BSLASH
        extends UnquoteMetaTransition {
            private BSLASH(IState s0, IState s1, ISymbol in) {
                super(s0, s1, in, '\\', '\\');
            }
        }

        private static class FORMFEED
        extends UnquoteMetaTransition {
            private FORMFEED(IState s0, IState s1, ISymbol in) {
                super(s0, s1, in, 'f', '\f');
            }
        }

        private static class BSPACE
        extends UnquoteMetaTransition {
            private BSPACE(IState s0, IState s1, ISymbol in) {
                super(s0, s1, in, 'b', '\b');
            }
        }

        private static class VTAB
        extends UnquoteMetaTransition {
            private VTAB(IState s0, IState s1, ISymbol in) {
                super(s0, s1, in, 'v', '\u000b');
            }
        }

        private static class TAB
        extends UnquoteMetaTransition {
            private TAB(IState s0, IState s1, ISymbol in) {
                super(s0, s1, in, 't', '\t');
            }
        }

        private static class ALARM
        extends UnquoteMetaTransition {
            private ALARM(IState s0, IState s1, ISymbol in) {
                super(s0, s1, in, 'a', '\u0007');
            }
        }

        private static class CR
        extends UnquoteMetaTransition {
            private CR(IState s0, IState s1, ISymbol in) {
                super(s0, s1, in, 'r', '\r');
            }
        }

        private static class LF
        extends UnquoteMetaTransition {
            private LF(IState s0, IState s1, ISymbol in) {
                super(s0, s1, in, 'n', '\n');
            }
        }
    }

    protected static class IsChar
    extends FilteredTransition.IObsoleteCondition {
        private final char c;

        public IsChar(char c) {
            this.c = c;
        }

        public boolean accept(ISymbol symbol, IMatchContext ctx) {
            if (symbol instanceof CharSymbol) {
                char d = ((CharSymbol)symbol).charValue();
                return this.c == d;
            }
            String name = symbol.getName();
            return name.length() == 1 && name.charAt(0) == this.c;
        }
    }
}

