/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.common.commands;

import com.ibm.appscan.cli.common.CLIConstants;
import com.ibm.appscan.cli.common.Messages;
import com.ibm.appscan.cli.common.components.Command;
import com.ibm.appscan.cli.common.handlers.HelpHandler;
import com.ibm.appscan.common.utils.SystemUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class HelpCommand
extends Command
implements CLIConstants {
    private HelpHandler m_handler;

    public HelpCommand() {
    }

    public HelpCommand(String[] args) {
        super(args);
    }

    @Override
    public void configure() {
        this.setNamespace(Messages.getMessage("namespace.global", new Object[0]));
        this.setName("help");
        this.setDescription(Messages.getMessage("command.help.description", new Object[0]));
        this.hasOptionalArg(true);
        this.setOptionalArgName("command");
        this.setOptions(new Options(), false);
    }

    @Override
    public Command createCommand(String[] args) {
        return new HelpCommand(args);
    }

    @Override
    public void execute() {
        String[] commands;
        CommandLine cmd = this.getCommandLine();
        if (cmd == null) {
            return;
        }
        if (this.m_handler == null) {
            this.m_handler = new HelpHandler();
        }
        if ((commands = cmd.getArgs()).length > 0) {
            for (int i = 0; i < commands.length; ++i) {
                this.m_handler.printHelp(commands[i]);
            }
        } else {
            this.m_handler.printHelp();
        }
    }

    @Override
    protected Options buildOptions() {
        return null;
    }

    public static boolean isHelpAlias(String command) {
        if (command != null) {
            command = command.trim().toLowerCase();
            if (SystemUtil.isWindows()) {
                return "/?".equals(command) || "/h".equals(command);
            }
            return "-h".equals(command) || "-help".equals(command) || "--help".equals(command);
        }
        return false;
    }
}

