/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.common.handlers;

import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.Messages;
import com.ibm.appscan.cli.common.components.Command;
import com.ibm.appscan.cli.common.model.ICommand;
import com.ibm.appscan.cli.common.model.ICommandManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IConsole;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HelpHandler {
    private IConsole m_console = CommonCLICore.getIOConsole();
    private ICommandManager m_commandManager = CommonCLICore.getCommandManager();

    public void printHelp() {
        List commands;
        List<ICommand> registeredCommands = this.m_commandManager.getRegisteredCommands();
        HashMap processedCommands = new HashMap();
        for (ICommand cmd : registeredCommands) {
            if (!processedCommands.containsKey(((Command)cmd).getNamespace())) {
                processedCommands.put(((Command)cmd).getNamespace(), new ArrayList());
            }
            if ((commands = (List)processedCommands.get(((Command)cmd).getNamespace())).contains(cmd)) continue;
            commands.add(cmd);
        }
        this.m_console.println(Messages.getMessage("command.help.usage", new Object[0]));
        this.m_console.println("\n");
        this.m_console.println(Messages.getMessage("command.help.page.description", new Object[0]));
        for (String namespace : processedCommands.keySet()) {
            this.m_console.println("\n");
            this.m_console.println(namespace);
            commands = (List)processedCommands.get(namespace);
            for (ICommand cmd : commands) {
                String alias = ((Command)cmd).getAlias();
                this.m_console.println(String.format("\t%-20s %-80s", ((Command)cmd).getName() + (alias == null ? "" : "/" + alias), ((Command)cmd).getDescription()));
            }
        }
    }

    public void printHelp(String command) {
        if (!this.m_commandManager.hasCommand(command)) {
            this.m_console.println(new Message(4, Messages.getMessage("command.invalid", command)));
        } else {
            this.m_commandManager.createCommand(command, null).printHelp();
        }
    }
}

