/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.highlevelapi.ejb2xhandler;

import com.ibm.appscan.frameworks.FrameworksInput;
import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.F4FHandler;
import com.ibm.appscan.frameworks.highlevelapi.ejb2xhandler.BeanInfo;
import com.ibm.appscan.frameworks.highlevelapi.ejb2xhandler.EjbConfigInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class Ejb2xHandler
extends F4FHandler {
    private static final Logger logger = TaintLogger.i().getLogger();
    List<EjbConfigInfo> configFiles = new ArrayList<EjbConfigInfo>();

    public void handleApp(F4FApp app, F4FActions actions) {
        logger.info((Object)Messages.getString((String)"framework.handler.running", (Object[])new Object[]{"EJB2X", "handleApp()"}));
        for (EjbConfigInfo ejbConfig : this.configFiles) {
            for (BeanInfo bean : ejbConfig.getBeans()) {
                logger.info((Object)Messages.getString((String)"framework.processing.class", (Object[])new Object[]{bean.getEndpointClass()}));
                if (bean.getEndpointClass() != null) {
                    IClass theEndpointClass = app.getAppClass(bean.getEndpointClass());
                    if (theEndpointClass != null) {
                        Collection methods = theEndpointClass.getAllMethods();
                        for (IMethod method : methods) {
                            String entrypoint = VDBJavaUtil.jvmToVDBSignature((String)method.getSignature());
                            if (entrypoint.indexOf("java.lang") == 0) continue;
                            int methodLoc = method.getSignature().lastIndexOf(".");
                            String entrySig = bean.getEjbClass() + entrypoint.substring(methodLoc);
                            logger.info((Object)Messages.getString((String)"framework.taint.callback", (Object[])new Object[]{entrySig}));
                            actions.addTaintedCallback(entrySig, method.getNumberOfParameters());
                        }
                    }
                } else {
                    logger.warn((Object)Messages.getString((String)"framework.missing", (Object[])new Object[]{"endpoint class"}));
                }
                try {
                    List<String> theInterfaces = bean.getLocalAndRemoteInterfaces();
                    for (String beanInterface : theInterfaces) {
                        IClass theInterfaceClass = app.getAppClass(beanInterface);
                        Collection theInterfaceMethods = theInterfaceClass.getAllMethods();
                        for (IMethod method : theInterfaceMethods) {
                            String theInterfaceSig = VDBJavaUtil.jvmToVDBSignature((String)method.getSignature());
                            int methodLoc = method.getSignature().lastIndexOf(".");
                            String theImplSig = bean.getEjbClass() + theInterfaceSig.substring(methodLoc);
                            if (theInterfaceSig.indexOf("java.lang") == 0 || theInterfaceSig.indexOf("javax.ejb") == 0) continue;
                            logger.info((Object)Messages.getString((String)"framework.replace.call", (Object[])new Object[]{theInterfaceSig, theImplSig}));
                            actions.replaceCalls(theInterfaceSig, theImplSig);
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
                }
            }
        }
        logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"EJB2X"}));
    }

    public boolean isApplicable() {
        logger.info((Object)Messages.getString((String)"framework.handler.running", (Object[])new Object[]{"EJB2X", "isApplicable()"}));
        FrameworksInput input = this.getFrameworksInput();
        Properties options = input.getOptions();
        String type = input.getType();
        if (!type.equals("Java")) {
            return false;
        }
        SortedSet<Object> theEjbConfigs = new TreeSet();
        theEjbConfigs = this.findEJBConfigLocations(this.getFrameworksInput().getProjectFileInfo().getSourceRoots());
        if (theEjbConfigs != null && theEjbConfigs.size() > 0) {
            try {
                for (String string : theEjbConfigs) {
                    EjbConfigInfo ejbConfigInfo = EjbConfigInfo.make(string, options.getProperty("javaee.core.loadExternalDTD").contentEquals("true"));
                    if (!ejbConfigInfo.isParsingSuccess()) continue;
                    this.configFiles.add(ejbConfigInfo);
                }
            }
            catch (Exception e) {
                logger.warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
                logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "false"}));
                logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"EJB2X"}));
                return false;
            }
        } else {
            logger.info((Object)Messages.getString((String)"framework.missing.file", (Object[])new Object[]{"ejb-jar.xml"}));
            logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "false"}));
            logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"EJB2X"}));
            return false;
        }
        if (this.configFiles.size() > 0) {
            logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "true"}));
            return true;
        }
        logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "false"}));
        logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"EJB2X"}));
        return false;
    }

    private SortedSet<String> findEJBConfigLocations(List<String> sourceRoots) {
        TreeSet<String> locations = new TreeSet<String>();
        if (sourceRoots == null || sourceRoots.size() == 0) {
            logger.warn((Object)Messages.getString((String)"framework.missing.file", (Object[])new Object[]{"ejb-jar.xml"}));
            return locations;
        }
        for (String root : sourceRoots) {
            File searchRoot = new File(root);
            logger.info((Object)Messages.getString((String)"framework.handler.searching", (Object[])new Object[]{"ejb-jar.xml", root}));
            try {
                List<File> theReturn = this.locateFile(searchRoot, "ejb-jar.xml");
                if (theReturn == null) {
                    logger.warn((Object)Messages.getString((String)"framework.missing.in", (Object[])new Object[]{"ejb-jar.xml", root}));
                } else if (theReturn.size() == 0) {
                    logger.warn((Object)Messages.getString((String)"framework.missing.in", (Object[])new Object[]{"ejb-jar.xml", root}));
                }
                if (theReturn == null || theReturn.size() <= 0) continue;
                for (File configLocation : theReturn) {
                    String theLocation = configLocation.getAbsolutePath();
                    logger.info((Object)Messages.getString((String)"framework.found", (Object[])new Object[]{theLocation}));
                    locations.add(theLocation);
                }
            }
            catch (Exception e) {
                logger.warn((Object)Messages.getString((String)"framework.missing.in", (Object[])new Object[]{"ejb-jar.xml", root}));
                logger.warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
            }
        }
        return locations;
    }

    private List<File> locateFile(File searchDir, String fileName) {
        ArrayList<File> theFiles = new ArrayList<File>();
        File[] searchFiles = searchDir.listFiles();
        try {
            if (searchFiles == null) {
                return null;
            }
            for (File searchFile : searchFiles) {
                if (searchFile.isDirectory()) {
                    theFiles.addAll(this.locateFile(searchFile, fileName));
                }
                if (!searchFile.getName().equalsIgnoreCase(fileName)) continue;
                theFiles.add(searchFile);
            }
        }
        catch (Exception e) {
            logger.warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
        return theFiles;
    }

    private void doBeanCallbacks(BeanInfo inBean) {
    }
}

