/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.aspdotnetmvc3;

import com.ibm.appscan.frameworks.analyzers.generic.DispatchResolver;
import com.ibm.appscan.frameworks.analyzers.generic.LangIndependentWalaUtil;
import com.ibm.appscan.frameworks.analyzers.generic.StringConstantFlow;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ViewResolverUtil {
    private static final String ACTION_RESULT_NAME = "LSystem/Web/Mvc/ActionResult";
    private static final String VIEW_RESULT_BASE_NAME = "LSystem/Web/Mvc/ViewResultBase";
    private static final String VIEW_RESULT_NAME = "LSystem/Web/Mvc/ViewResult";
    private static final String DOT_NET_STRING_TYPE = "LSystem/String";
    private static final String VIEW_RESULT_SET_VIEW_NAME_SIG = "set_ViewName";
    private static final String CONTROLLER_VIEW_METHOD_NAME = "View";
    private static final String CONTROLLER_PARTIAL_VIEW_METHOD_NAME = "PartialView";
    private static final int MAX_CALL_DEPTH = 1;
    private AnalysisCache resolverCache = new AnalysisCache();

    public Set<String> getPossibleViewNames(IMethod controllerMethod) {
        IR ir;
        HashSet result = HashSetFactory.make();
        TypeReference returnType = controllerMethod.getReturnType();
        if ((returnType.getName().toString().equals(ACTION_RESULT_NAME) || returnType.getName().toString().equals(VIEW_RESULT_BASE_NAME) || returnType.getName().toString().equals(VIEW_RESULT_NAME)) && (ir = LangIndependentWalaUtil.getIR((IMethod)controllerMethod, (AnalysisCache)this.resolverCache)) != null) {
            DefUse du = LangIndependentWalaUtil.getDU((IR)ir, (AnalysisCache)this.resolverCache);
            DispatchResolver dispatchResolver = DispatchResolver.make((IClassHierarchy)controllerMethod.getClassHierarchy());
            for (SSAInstruction instr : Iterator2Iterable.make((Iterator)ir.iterateNormalInstructions())) {
                if (!(instr instanceof SSAReturnInstruction)) continue;
                int returnedVal = instr.getUse(0);
                this.handleReturnStatement(controllerMethod, ir, du, returnedVal, dispatchResolver, result);
            }
        }
        return result;
    }

    private void handleReturnStatement(IMethod controllerMethod, IR ir, DefUse du, int returnedVal, DispatchResolver dispatchResolver, Collection<String> possibleNames) {
        SSAInstruction def = du.getDef(returnedVal);
        if (def instanceof SSAPhiInstruction) {
            SSAPhiInstruction phiInstruction = (SSAPhiInstruction)def;
            int numOfUses = phiInstruction.getNumberOfUses();
            for (int i = 0; i < numOfUses; ++i) {
                int useVal = phiInstruction.getUse(i);
                SSAInstruction useDef = du.getDef(useVal);
                this.handleReturnStatementSingleFlow(controllerMethod, useDef, ir, du, useVal, dispatchResolver, possibleNames);
            }
        } else {
            this.handleReturnStatementSingleFlow(controllerMethod, def, ir, du, returnedVal, dispatchResolver, possibleNames);
        }
    }

    private void handleReturnStatementSingleFlow(IMethod controllerMethod, SSAInstruction def, IR ir, DefUse du, int returnedVal, DispatchResolver dispatchResolver, Collection<String> possibleNames) {
        if (this.isReturnCallsControllerMethod(def, CONTROLLER_VIEW_METHOD_NAME) || this.isReturnCallsControllerMethod(def, CONTROLLER_PARTIAL_VIEW_METHOD_NAME)) {
            this.handleReturnStatementViewCall(controllerMethod, def, ir, du, possibleNames);
        } else {
            this.handleReturnStatementViewResult(controllerMethod, def, ir, du, returnedVal, dispatchResolver, possibleNames);
        }
    }

    private void handleReturnStatementViewResult(IMethod controllerMethod, SSAInstruction def, IR ir, DefUse du, int returnedVal, DispatchResolver dispatchResolver, Collection<String> possibleNames) {
        Collection<Pair<IMethod, Integer>> valsAssignedViewResult = this.getViewResultVals(controllerMethod, ir, du, returnedVal, dispatchResolver, 0);
        for (Pair<IMethod, Integer> p : valsAssignedViewResult) {
            IMethod m = (IMethod)p.fst;
            IR tmpIR = LangIndependentWalaUtil.getIR((IMethod)m, (AnalysisCache)this.resolverCache);
            DefUse tmpDU = LangIndependentWalaUtil.getDU((IR)tmpIR, (AnalysisCache)this.resolverCache);
            this.handlesViewNamesForVal(possibleNames, tmpIR, tmpDU, (Integer)p.snd);
        }
    }

    private boolean isReturnCallsControllerMethod(SSAInstruction def, String methodSig) {
        if (!(def instanceof SSAAbstractInvokeInstruction)) {
            return false;
        }
        SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)def;
        MethodReference invokedRef = invoke.getDeclaredTarget();
        return invokedRef.getName().toString().equals(methodSig);
    }

    private void handleReturnStatementViewCall(IMethod controllerMethod, SSAInstruction def, IR ir, DefUse du, Collection<String> possibleNames) {
        SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)def;
        MethodReference invokedRef = invoke.getDeclaredTarget();
        if (invokedRef.getNumberOfParameters() > 0) {
            TypeReference firstParamType = invokedRef.getParameterType(0);
            if (firstParamType.getName().toString().equals(DOT_NET_STRING_TYPE)) {
                this.getStringsForParam(invoke, 0, ir, du, possibleNames);
            } else {
                this.addDefaultViewName(controllerMethod, possibleNames);
            }
        } else {
            this.addDefaultViewName(controllerMethod, possibleNames);
        }
    }

    private void addDefaultViewName(IMethod controllerMethod, Collection<String> possibleNames) {
        String viewName = null;
        viewName = controllerMethod.getName().toString();
        if (null != viewName) {
            possibleNames.add(viewName);
        }
    }

    private Collection<Pair<IMethod, Integer>> getViewResultVals(IMethod m, IR ir, DefUse du, int val, DispatchResolver dispatchResolver, int curDepth) {
        HashSet result = HashSetFactory.make();
        SSAInstruction def = du.getDef(val);
        if (def instanceof SSANewInstruction) {
            result.add(Pair.make((Object)m, (Object)val));
        } else if (def instanceof SSAAbstractInvokeInstruction && curDepth < 1) {
            SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)def;
            TypeAbstraction receiverType = null;
            if (invoke.isDispatch()) {
                TypeInference ti = TypeInference.make((IR)ir, (boolean)false);
                receiverType = ti.getType(invoke.getReceiver());
            }
            Set possibleTargets = dispatchResolver.computePossibleTargets(invoke.getCallSite(), receiverType);
            for (IMethod target : possibleTargets) {
                IR targetIR = LangIndependentWalaUtil.getIR((IMethod)target, (AnalysisCache)this.resolverCache);
                if (targetIR == null) continue;
                for (SSAInstruction targetInstr : Iterator2Iterable.make((Iterator)targetIR.iterateNormalInstructions())) {
                    if (!(targetInstr instanceof SSAReturnInstruction)) continue;
                    result.addAll(this.getViewResultVals(target, targetIR, LangIndependentWalaUtil.getDU((IR)targetIR, (AnalysisCache)this.resolverCache), targetInstr.getUse(0), dispatchResolver, curDepth + 1));
                }
            }
        }
        return result;
    }

    private void handlesViewNamesForVal(Collection<String> result, IR ir, DefUse du, int viewResultVal) {
        for (SSAInstruction use : Iterator2Iterable.make((Iterator)du.getUses(viewResultVal))) {
            if (!(use instanceof SSAAbstractInvokeInstruction)) continue;
            SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)use;
            MethodReference targetRef = invoke.getDeclaredTarget();
            this.getViewNameFromCall(result, ir, du, invoke, targetRef, VIEW_RESULT_SET_VIEW_NAME_SIG);
        }
    }

    private void getViewNameFromCall(Collection<String> result, IR ir, DefUse du, SSAAbstractInvokeInstruction invoke, MethodReference targetRef, String functionCall) {
        TypeReference parameterType;
        if (targetRef.getName().toString().equals(functionCall) && targetRef.getDeclaringClass().getName().toString().equals(VIEW_RESULT_BASE_NAME) && targetRef.getNumberOfParameters() > 0 && (parameterType = targetRef.getParameterType(0)).getName().toString().equals(DOT_NET_STRING_TYPE)) {
            this.getStringsForParam(invoke, 0, ir, du, result);
        }
    }

    private void getStringsForParam(SSAAbstractInvokeInstruction invoke, int paramIndex, IR ir, DefUse du, Collection<String> result) {
        int viewParam = invoke.getUse(paramIndex + 1);
        StringConstantFlow flow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)du);
        result.addAll(flow.findIntraprocStringsFlowingToVar(viewParam));
    }
}

