/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.aspdotnetmvc3;

import com.ibm.appscan.frameworks.FrameworksInput;
import com.ibm.appscan.frameworks.aspdotnet.util.DotNetVDBUtil;
import com.ibm.appscan.frameworks.aspdotnet.util.Utils;
import com.ibm.appscan.frameworks.handlers.aspdotnetmvc3.CallReplacementCreator;
import com.ibm.appscan.frameworks.handlers.aspdotnetmvc3.EntrypointCreator;
import com.ibm.appscan.frameworks.handlers.aspdotnetmvc3.MvcController;
import com.ibm.appscan.frameworks.handlers.aspdotnetmvc3.MvcControllerFinder;
import com.ibm.appscan.frameworks.handlers.aspdotnetmvc3.MvcViewFinder;
import com.ibm.appscan.frameworks.handlers.aspdotnetmvc3.SyntheticMethodCreator;
import com.ibm.appscan.frameworks.handlers.aspdotnetmvc3.ViewResolverUtil;
import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.F4FHandler;
import com.ibm.appscan.frameworks.highlevelapi.processing.F4FActionProcessor;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class Mvc3Handler
extends F4FHandler {
    private final boolean useMultipleSyntheticMethods = true;
    private static final Logger logger = TaintLogger.i().getLogger();

    public void handleApp(F4FApp app, F4FActions actions) {
        logger.info((Object)Messages.getString((String)"framework.handler.running", (Object[])new Object[]{"AspDotNetMVC3", "handleApp()"}));
        MvcControllerFinder mvcControllerFinder = new MvcControllerFinder(app);
        if (!mvcControllerFinder.Initialize()) {
            TaintLogger.i().getLogger().error((Object)"AspDotNetMvc3Handler:: Unable to initialize MvcControllerFinder");
            return;
        }
        FrameworksInput fwInput = this.getFrameworksInput();
        EntrypointCreator entrypointCreator = new EntrypointCreator(fwInput, app);
        Collection<MvcController> controllers = mvcControllerFinder.findControllers();
        MvcViewFinder mvcViewFinder = new MvcViewFinder(this.getFrameworksInput(), app);
        mvcViewFinder.findViews();
        ViewResolverUtil viewNameResolver = new ViewResolverUtil();
        SyntheticMethodCreator syntheticMethodCreator = new SyntheticMethodCreator(app, actions, entrypointCreator);
        CallReplacementCreator callReplacements = new CallReplacementCreator(app, actions);
        for (MvcController mvcController : controllers) {
            Collection<IMethod> actionMethods = mvcController.getActions();
            for (IMethod iMethod : actionMethods) {
                if (iMethod.isAbstract()) continue;
                Set<String> viewPossibleNames = viewNameResolver.getPossibleViewNames(iMethod);
                if (viewPossibleNames.isEmpty()) {
                    TaintLogger.i().getLogger().info((Object)("No view found for " + F4FActionProcessor.getVDBSig((IMethod)iMethod)));
                    callReplacements.addMethodWithoutViews(iMethod.getSignature());
                    HashSet viewPossibleClasses = HashSetFactory.make();
                    syntheticMethodCreator.CreateSyntheticMethod(mvcController.getControllerClass(), iMethod, viewPossibleClasses);
                    continue;
                }
                this.generateSyntheticMethodPerView(mvcController, iMethod, mvcViewFinder, viewPossibleNames, syntheticMethodCreator);
            }
        }
        entrypointCreator.generateEntryPoints();
        callReplacements.generateCallReplacements();
        logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"AspDotNetMVC3"}));
    }

    private void generateSyntheticMethodPerView(MvcController mvcController, IMethod iMethod, MvcViewFinder mvcViewFinder, Set<String> viewPossibleNames, SyntheticMethodCreator syntheticMethodCreator) {
        String viewName2 = null;
        IClass viewClass = null;
        for (String viewName2 : viewPossibleNames) {
            if (viewName2 == null || (viewClass = mvcViewFinder.getViewByName(mvcController.getControllerName(), viewName2)) == null) continue;
            logger.info((Object)Messages.getString((String)"framework.view.found", (Object[])new Object[]{F4FActionProcessor.getVDBSig((IMethod)iMethod) + " : " + DotNetVDBUtil.walaDotNet2VDBType((String)viewClass.getName().toString())}));
            HashSet viewPossibleClasses = HashSetFactory.make();
            viewPossibleClasses.add(viewClass);
            syntheticMethodCreator.CreateSyntheticMethod(mvcController.getControllerClass(), iMethod, viewPossibleClasses);
        }
    }

    private void generateSingleSyntheticMethodForAllViews(MvcController mvcController, IMethod iMethod, MvcViewFinder mvcViewFinder, Set<String> viewPossibleNames, SyntheticMethodCreator syntheticMethodCreator) {
        HashSet viewPossibleClasses = HashSetFactory.make();
        String viewName2 = null;
        IClass viewClass = null;
        for (String viewName2 : viewPossibleNames) {
            if (viewName2 == null || (viewClass = mvcViewFinder.getViewByName(mvcController.getControllerName(), viewName2)) == null) continue;
            logger.info((Object)Messages.getString((String)"framework.view.found", (Object[])new Object[]{F4FActionProcessor.getVDBSig((IMethod)iMethod) + " : " + DotNetVDBUtil.walaDotNet2VDBType((String)viewClass.getName().toString())}));
            viewPossibleClasses.add(viewClass);
        }
        syntheticMethodCreator.CreateSyntheticMethod(mvcController.getControllerClass(), iMethod, viewPossibleClasses);
    }

    public boolean isApplicable() {
        logger.info((Object)Messages.getString((String)"framework.handler.running", (Object[])new Object[]{"AspDotNetMVC3", "isApplicable()"}));
        FrameworksInput fwInput = this.getFrameworksInput();
        if (!Utils.IsDotNetFramework((FrameworksInput)fwInput)) {
            logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "false"}));
            logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"AspDotNetMVC3"}));
            return false;
        }
        if (Utils.IsSystemWebMvcInScope((FrameworksInput)fwInput).booleanValue()) {
            logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "true"}));
            return true;
        }
        String csProjPath = Utils.GetCsprojPath((FrameworksInput)fwInput);
        if (csProjPath.isEmpty()) {
            logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "false"}));
            logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"AspDotNetMVC3"}));
            return false;
        }
        String mvcReference = Utils.SearchForMvcDllReference((String)csProjPath);
        if (mvcReference.isEmpty()) {
            logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "false"}));
            logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"AspDotNetMVC3"}));
            return false;
        }
        boolean mvcVersionLegal = Utils.IsMvcVersionLegal((String)mvcReference);
        if (!mvcVersionLegal) {
            logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "false"}));
            logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"AspDotNetMVC3"}));
            return false;
        }
        logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "true"}));
        return true;
    }
}

