/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.aspdotnetmvc3;

import com.ibm.appscan.frameworks.aspdotnet.util.DotNetVDBUtil;
import com.ibm.appscan.frameworks.handlers.aspdotnetmvc3.MvcController;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.processing.F4FActionProcessor;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.types.annotations.Annotation;
import java.util.ArrayList;
import java.util.Collection;

public class MvcControllerFinder {
    private F4FApp app;
    private IClass iControllerInterface;
    private IClass controllerClass;
    private IClass nonActionAttributeClass;

    public MvcControllerFinder(F4FApp app) {
        this.app = app;
    }

    public boolean Initialize() {
        this.iControllerInterface = this.app.getIClass("System.Web.Mvc.IController");
        this.controllerClass = this.app.getIClass("System.Web.Mvc.Controller");
        this.nonActionAttributeClass = this.app.getIClass("System.Web.Mvc.NonActionAttribute");
        boolean success = true;
        if (this.iControllerInterface == null) {
            TaintLogger.i().getLogger().error((Object)Messages.getString((String)"framework.missing", (Object[])new Object[]{"System.Web.Mvc.IController"}));
            success = false;
        }
        if (this.controllerClass == null) {
            TaintLogger.i().getLogger().error((Object)Messages.getString((String)"framework.missing", (Object[])new Object[]{"System.Web.Mvc.Controller"}));
            success = false;
        }
        if (this.nonActionAttributeClass == null) {
            TaintLogger.i().getLogger().error((Object)Messages.getString((String)"framework.missing", (Object[])new Object[]{"System.Web.Mvc.NonActionAttribute"}));
            success = false;
        }
        return success;
    }

    public Collection<MvcController> findControllers() {
        ArrayList<MvcController> results = new ArrayList<MvcController>();
        Collection classes = this.app.getAllApplicationClasses();
        for (IClass iClass : classes) {
            if (this.isControllerClass(iClass)) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.class.found", (Object[])new Object[]{"controller: " + DotNetVDBUtil.walaDotNet2VDBType((String)iClass.getName().toString())}));
                Collection<IMethod> actions = this.getActions(iClass);
                MvcController controller = new MvcController(iClass, actions);
                results.add(controller);
                continue;
            }
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.ignored.class", (Object[])new Object[]{"non-controller: " + DotNetVDBUtil.walaDotNet2VDBType((String)iClass.getName().toString())}));
        }
        return results;
    }

    private boolean isControllerClass(IClass iClass) {
        return iClass != null && iClass.isPublic() && iClass.getName().toString().toLowerCase().endsWith("controller") && !iClass.isAbstract() && this.implementsInterface(iClass, this.iControllerInterface);
    }

    private Collection<IMethod> getActions(IClass iClass) {
        ArrayList<IMethod> results = new ArrayList<IMethod>();
        Collection allMethods = iClass.getAllMethods();
        for (IMethod iMethod : allMethods) {
            String methodVDBSignature = F4FActionProcessor.getVDBSig((IMethod)iMethod);
            if (iMethod.isInit() || iMethod.isStatic() || !iMethod.isPublic()) {
                StringBuilder message = new StringBuilder(Messages.getString((String)"framework.ignored.method", (Object[])new Object[]{"non-action: "}));
                if (!iMethod.isPublic()) {
                    message.append(" non-public");
                }
                if (iMethod.isStatic()) {
                    message.append(" static");
                }
                if (iMethod.isInit()) {
                    message.append(" constructor");
                }
                message.append(": ");
                message.append(methodVDBSignature);
                TaintLogger.i().getLogger().info((Object)message.toString());
                continue;
            }
            if (iMethod.getName().toString().startsWith("get_") || iMethod.getName().toString().startsWith("set_")) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.ignored.method", (Object[])new Object[]{"getter/setter: " + methodVDBSignature}));
                continue;
            }
            if (this.isAssignable(this.controllerClass, iMethod.getDeclaringClass())) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.ignored.method", (Object[])new Object[]{"defined by System.Web.Mvc.Controller or one of its superclasses: " + methodVDBSignature}));
                continue;
            }
            if (this.hasAttribute(iMethod, this.nonActionAttributeClass)) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.ignored.method", (Object[])new Object[]{"NonAction: " + methodVDBSignature}));
                continue;
            }
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.method.found", (Object[])new Object[]{"action method: " + methodVDBSignature}));
            results.add(iMethod);
        }
        return results;
    }

    private boolean hasAttribute(IMethod iMethod, IClass attributeClass) {
        Collection annotations = this.app.getMethodAnnotations(iMethod);
        for (Annotation annotation : annotations) {
            if (!annotation.getType().getName().equals((Object)attributeClass.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean implementsInterface(IClass iClass, IClass interfaceClass) {
        Collection implementedInterfaces = iClass.getAllImplementedInterfaces();
        for (IClass iface : implementedInterfaces) {
            if (!iface.equals(interfaceClass)) continue;
            return true;
        }
        return false;
    }

    private boolean inheritsFrom(IClass subClass, IClass parentClass) {
        for (IClass parent = subClass; parent != null; parent = parent.getSuperclass()) {
            if (!parent.equals(parentClass)) continue;
            return true;
        }
        return false;
    }

    private boolean isAssignable(IClass from, IClass to) {
        if (to.isInterface()) {
            return this.implementsInterface(from, to);
        }
        return this.inheritsFrom(from, to);
    }
}

