/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.aspdotnetmvc3;

import com.ibm.appscan.frameworks.analyzers.generic.LangIndependentWalaUtil;
import com.ibm.appscan.frameworks.aspdotnet.util.DotNetVDBUtil;
import com.ibm.appscan.frameworks.aspdotnet.util.Utils;
import com.ibm.appscan.frameworks.handlers.aspdotnetmvc3.AspDotNetValidator;
import com.ibm.appscan.frameworks.handlers.aspdotnetmvc3.EntrypointCreator;
import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.processing.F4FActionProcessor;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.HighLevelSyntheticMethod;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Local;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Param;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Taint;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SyntheticMethodCreator {
    private F4FActions f4fActions;
    private F4FApp f4fApp;
    private int counter = 0;
    private final Logger taintLogger = TaintLogger.i().getLogger();
    private Map<String, AspDotNetValidator> validatorMap = new HashMap<String, AspDotNetValidator>();
    private EntrypointCreator entrypointCreator;

    public SyntheticMethodCreator(F4FApp f4fApp, F4FActions f4fActions, EntrypointCreator entrypointCreator) {
        this.f4fActions = f4fActions;
        this.f4fApp = f4fApp;
        this.entrypointCreator = entrypointCreator;
    }

    public void CreateSyntheticMethod(IClass controllerClass, IMethod actionMethod, Set<IClass> viewPossibleClasses) {
        try {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.class.found", (Object[])new Object[]{controllerClass.getName().toString()}));
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.method.found", (Object[])new Object[]{actionMethod.getName().toString()}));
            String controllerVdb = F4FActionProcessor.getVDBTypeName((IClass)controllerClass);
            FilePositionInfo methodFilePosInfo = Utils.getMethodPosition((IMethod)actionMethod);
            ++this.counter;
            String hlVdb = "AppScan.Synthetic.dotNetMVC." + controllerVdb.replace(".", "_") + "_" + actionMethod.getName().toString() + "_" + this.counter + "():System.Void";
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.begin.syntheticmethod", (Object[])new Object[]{hlVdb}));
            HighLevelSyntheticMethod hlMethod = HighLevelSyntheticMethod.make((String)hlVdb);
            Param[] theParams = new Param[actionMethod.getNumberOfParameters()];
            int numParameters = actionMethod.getNumberOfParameters();
            try {
                AnalysisCache cache = new AnalysisCache();
                IR ir = LangIndependentWalaUtil.getIR((IMethod)actionMethod, (AnalysisCache)cache);
                for (int i = 1; i < numParameters; ++i) {
                    IClass theClassType = this.f4fApp.getClassHierarchy().lookupClass(actionMethod.getParameterType(i));
                    String theParamName = null;
                    theParamName = actionMethod.hasLocalVariableTable() ? ir.getLocalNames(0, ir.getParameter(i - 1))[0] : "parameter_" + i;
                    if (theClassType == null) {
                        TaintLogger.i().getLogger().info((Object)"Inside SyntheticMethodCreator#CreateSyntheticMethod(), looping through parameters.  theClassType of this parameter is null!!  Skipping...");
                        continue;
                    }
                    TypeReference classTypeRef = theClassType.getReference();
                    if (classTypeRef == null) {
                        TaintLogger.i().getLogger().info((Object)"Inside SyntheticMethodCreator#CreateSyntheticMethod(), looping through parameters.  classTypeRef of this parameter is null!!  Skipping...");
                        continue;
                    }
                    if (classTypeRef.isClassType() && !theClassType.getName().toString().startsWith("System", 1) && SyntheticMethodCreator.containsAttributeBindExclude(theClassType, this.f4fApp, actionMethod, i - 1)) {
                        TypeReference paramType = actionMethod.getParameterType(i);
                        String paramTypeName = "System.Object";
                        if (paramType != null) {
                            try {
                                paramTypeName = DotNetVDBUtil.convertWalaDotNetGenericSig2VDB((TypeReference)paramType, (IClassHierarchy)this.f4fApp.getClassHierarchy());
                            }
                            catch (Exception e) {
                                TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
                            }
                        }
                        Local theLocal = hlMethod.newLocal(paramTypeName);
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.local", (Object[])new Object[]{theLocal.getName()}));
                        for (IField field : theClassType.getAllInstanceFields()) {
                            if (SyntheticMethodCreator.isBindExcluded(theClassType, this.f4fApp, field.getName().toString(), actionMethod, i - 1)) continue;
                            String paramFieldName = null;
                            if (theParamName != null) {
                                paramFieldName = theParamName + "." + field.getName().toString();
                            }
                            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.taint.found", (Object[])new Object[]{"parameter " + i + " " + paramFieldName}));
                            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.write", (Object[])new Object[]{theLocal.getName()}));
                            hlMethod.addInstanceVariableWrite(theLocal, field, this.taintToProperType(paramFieldName, field.getFieldTypeReference().getName().toString(), hlMethod, methodFilePosInfo), null);
                        }
                        theParams[i] = theLocal;
                        continue;
                    }
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.taint.found", (Object[])new Object[]{"parameter " + i + " " + theParamName}));
                    theParams[i] = this.taintToProperType(theParamName, actionMethod.getParameterType(i).getName().toString(), hlMethod, methodFilePosInfo);
                }
            }
            catch (Exception e) {
                String txt = "";
                if (e.getMessage() != null) {
                    txt = e.getMessage();
                }
                TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{txt}));
                TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
            }
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{actionMethod.getName().toString()}));
            Local returnVariable = hlMethod.addCall(actionMethod, methodFilePosInfo, theParams);
            if (returnVariable != null && returnVariable.getDeclaredVDBType().equals("System.String")) {
                Param[] responseParams = new Param[2];
                responseParams[1] = returnVariable;
                String vdbWrite = "System.Web.HttpResponse.Write(System.String):System.Void";
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{vdbWrite}));
                hlMethod.addCall(vdbWrite, methodFilePosInfo, responseParams);
            }
            String theUrl = Utils.GetUrl((IClass)controllerClass, (IMethod)actionMethod);
            HashSet<String> urlSet = new HashSet<String>();
            urlSet.add(theUrl);
            HashMap vdb2Urls = HashMapFactory.make();
            vdb2Urls.put(hlMethod.getVdbSignature(), urlSet);
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.method.url", (Object[])new Object[]{hlMethod.getVdbSignature(), theUrl}));
            F4FActionProcessor.addUrls((Map)vdb2Urls);
            if (viewPossibleClasses != null && !viewPossibleClasses.isEmpty()) {
                IClass viewClass2 = null;
                for (IClass viewClass2 : viewPossibleClasses) {
                    this.addSingleViewExecution(hlMethod, methodFilePosInfo, viewClass2);
                }
            }
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.syntheticmethod", (Object[])new Object[]{hlMethod.getVdbSignature()}));
            this.f4fActions.addHighLevelSyntheticMethod(hlMethod);
        }
        catch (Exception e) {
            String txt = "";
            if (e.getMessage() != null) {
                txt = e.getMessage();
            }
            TaintLogger.i().getLogger().error((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{txt}));
            TaintLogger.i().getLogger().error((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
    }

    private void addSingleViewExecution(HighLevelSyntheticMethod hlMethod, FilePositionInfo methodFilePosInfo, IClass viewClass) {
        String viewVdb = null;
        if (viewClass != null && (viewVdb = F4FActionProcessor.getVDBTypeName((IClass)viewClass)) != null) {
            String executeVdb = viewVdb + ".Execute():System.Void";
            Param[] emptyParams = new Param[]{};
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{executeVdb}));
            hlMethod.addCall(executeVdb, methodFilePosInfo, emptyParams);
            this.entrypointCreator.addExcludedEntrypoint(executeVdb);
        }
    }

    private Param taintToProperType(String paramName, String targetTypeName, HighLevelSyntheticMethod method, FilePositionInfo position) {
        Taint result;
        Taint taint = result = paramName != null ? Taint.taintWithParamName((String)paramName) : Taint.taint();
        if (targetTypeName != null) {
            if (targetTypeName.equals("PSystem/Double")) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"System.Double.Parse(System.String):System.Double"}));
                result = method.addCall("System.Double.Parse(System.String):System.Double", position, new Param[]{result});
            } else if (targetTypeName.equals("PSystem/Single")) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"System.Single.Parse(System.String):System.Single"}));
                result = method.addCall("System.Single.Parse(System.String):System.Single", position, new Param[]{result});
            } else if (targetTypeName.equals("LSystem/Decimal")) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"System.Decimal.Parse(System.String):System.Decimal"}));
                result = method.addCall("System.Decimal.Parse(System.String):System.Decimal", position, new Param[]{result});
            } else if (targetTypeName.equals("PSystem/UInt64")) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"System.UInt64.Parse(System.String):System.UInt64"}));
                result = method.addCall("System.UInt64.Parse(System.String):System.UInt64", position, new Param[]{result});
            } else if (targetTypeName.equals("PSystem/Int64")) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"System.Int64.Parse(System.String):System.Int64"}));
                result = method.addCall("System.Int64.Parse(System.String):System.Int64", position, new Param[]{result});
            } else if (targetTypeName.equals("PSystem/UInt32")) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"System.UInt32.Parse(System.String):System.UInt32"}));
                result = method.addCall("System.UInt32.Parse(System.String):System.UInt32", position, new Param[]{result});
            } else if (targetTypeName.equals("PSystem/Int32")) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"System.Int32.Parse(System.String):System.Int32"}));
                result = method.addCall("System.Int32.Parse(System.String):System.Int32", position, new Param[]{result});
            } else if (targetTypeName.equals("PSystem/UInt16")) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"System.UInt16.Parse(System.String):System.UInt16"}));
                result = method.addCall("System.UInt16.Parse(System.String):System.UInt16", position, new Param[]{result});
            } else if (targetTypeName.equals("PSystem/Int16")) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"System.Int16.Parse(System.String):System.Int16"}));
                result = method.addCall("System.Int16.Parse(System.String):System.Int16", position, new Param[]{result});
            } else if (targetTypeName.equals("PSystem/Byte")) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"System.Byte.Parse(System.String):System.Byte"}));
                result = method.addCall("System.Byte.Parse(System.String):System.Byte", position, new Param[]{result});
            } else if (targetTypeName.equals("PSystem/SByte")) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"System.SByte.Parse(System.String):System.SByte"}));
                result = method.addCall("System.SByte.Parse(System.String):System.SByte", position, new Param[]{result});
            } else if (targetTypeName.equals("PSystem/Char")) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"System.Char.Parse(System.String):System.Char"}));
                result = method.addCall("System.Char.Parse(System.String):System.Char", position, new Param[]{result});
            } else if (targetTypeName.equals("PSystem/Boolean")) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"System.Boolean.Parse(System.String):System.Boolean"}));
                result = method.addCall("System.Boolean.Parse(System.String):System.Boolean", position, new Param[]{result});
            }
        }
        return result;
    }

    private static boolean containsAttributeBindExclude(IClass theClass, F4FApp app, IMethod method, int paramNumber) {
        String bindAttributeName = "LSystem/Web/Mvc/BindAttribute";
        Collection elementAnnotations = null;
        elementAnnotations = app.getClassAnnotations(theClass);
        if (elementAnnotations != null) {
            for (Annotation annotation : elementAnnotations) {
                if (!annotation.getType().getName().toString().equals(bindAttributeName)) continue;
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.attribute.found", (Object[])new Object[]{annotation.getType().getName().toString()}));
                Map namedArgs = annotation.getNamedArguments();
                if (namedArgs == null || !namedArgs.containsKey("Exclude")) continue;
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.attribute.found", (Object[])new Object[]{"Exclude"}));
                return true;
            }
        }
        Collection[] paramAnnotations = app.getMethodParametersAnnotations(method);
        for (Annotation annotation : paramAnnotations[paramNumber]) {
            Map namedArgs;
            if (!annotation.getType().getName().toString().equals(bindAttributeName) || (namedArgs = annotation.getNamedArguments()) == null || !namedArgs.containsKey("Exclude")) continue;
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.attribute.found", (Object[])new Object[]{"Exclude"}));
            return true;
        }
        return false;
    }

    private static boolean isBindExcluded(IClass element, F4FApp app, String fieldName, IMethod method, int paramNumber) {
        String bindAttributeName = "LSystem/Web/Mvc/BindAttribute";
        Collection elementAnnotations = null;
        elementAnnotations = app.getClassAnnotations(element);
        if (elementAnnotations != null) {
            for (Annotation annotation : elementAnnotations) {
                if (!annotation.getType().getName().toString().equals(bindAttributeName)) continue;
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.attribute.found", (Object[])new Object[]{annotation.getType().getName().toString()}));
                if (!SyntheticMethodCreator.attributeExcludes(annotation, fieldName)) continue;
                return true;
            }
        }
        Collection[] paramAnnotations = app.getMethodParametersAnnotations(method);
        for (Annotation annotation : paramAnnotations[paramNumber]) {
            if (!annotation.getType().getName().toString().equals(bindAttributeName) || !SyntheticMethodCreator.attributeExcludes(annotation, fieldName)) continue;
            return true;
        }
        return false;
    }

    private static boolean attributeExcludes(Annotation annotation, String fieldName) {
        Map namedArgs;
        if (annotation != null && (namedArgs = annotation.getNamedArguments()) != null && namedArgs.containsKey("Exclude")) {
            String[] values = ((AnnotationsReader.ElementValue)namedArgs.get("Exclude")).toString().split(",");
            for (int i = 0; i < values.length; ++i) {
                String paramFormat = "<" + values[i] + ">";
                if (!fieldName.contains(paramFormat)) continue;
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.attribute.found", (Object[])new Object[]{"Exclude" + paramFormat}));
                return true;
            }
        }
        return false;
    }

    private void handleValidators(IMethod actionMethod, IClass actionMethodClazz, HighLevelSyntheticMethod caller, Param[] theParams) {
        if (actionMethod.isAbstract()) {
            return;
        }
        for (int index = 1; index < actionMethod.getNumberOfParameters(); ++index) {
            TypeReference typeRef;
            TypeReference modelTypeRef = typeRef = actionMethod.getParameterType(index);
            int indexOfModelParam = index;
            HighLevelSyntheticMethod validatorSynMethod = this.getValidateSynMethodForModel(modelTypeRef);
            if (validatorSynMethod == null) continue;
            FilePositionInfo methodFilePosInfo = Utils.getMethodPosition((IMethod)actionMethod);
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{validatorSynMethod.getVdbSignature()}));
            Local localValue = caller.addCall(validatorSynMethod.getVdbSignature(), methodFilePosInfo, new Param[]{theParams[indexOfModelParam]});
            theParams[indexOfModelParam] = localValue;
        }
    }

    private HighLevelSyntheticMethod getValidateSynMethodForModel(TypeReference modelTypeRef) {
        String modelVdbSig = Utils.getVDBSignature((TypeReference)modelTypeRef);
        if (this.validatorMap.containsKey(modelVdbSig)) {
            return this.validatorMap.get(modelVdbSig).getModelValidateSynMethod();
        }
        AspDotNetValidator validator = new AspDotNetValidator(modelTypeRef, this.f4fApp);
        HighLevelSyntheticMethod validatorSynMethod = validator.getModelValidateSynMethod();
        if (validatorSynMethod != null) {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.syntheticmethod", (Object[])new Object[]{validatorSynMethod.getVdbSignature()}));
            this.f4fActions.addHighLevelSyntheticMethod(validatorSynMethod, false);
            this.validatorMap.put(modelVdbSig, validator);
            return validatorSynMethod;
        }
        return null;
    }
}

