/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dotnet.cil;

import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.types.FieldReference;

public abstract class CILFieldAccessInstruction
implements IInstruction {
    private final FieldReference fieldRef;
    protected final boolean isStatic;

    CILFieldAccessInstruction(FieldReference fieldRef, boolean isStatic) {
        this.fieldRef = fieldRef;
        this.isStatic = isStatic;
    }

    public String getClassType() {
        return this.fieldRef.getDeclaringClass().getName().toString();
    }

    public String getFieldName() {
        return this.fieldRef.getName().toString();
    }

    public String getFieldType() {
        return this.fieldRef.getFieldType().getName().toString();
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public int[] getBranchTargets() {
        return Instruction.noInstructions;
    }

    public int getPoppedCount() {
        return this.isStatic ? 1 : 2;
    }

    public boolean isFallThrough() {
        return true;
    }

    public boolean isPEI() {
        return true;
    }

    public IInstruction redirectTargets(int[] targetMap) {
        return this;
    }
}

