/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dotnet.cil;

import com.ibm.wala.dotnet.cil.Translator;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IStoreInstruction;
import com.ibm.wala.shrikeBT.Instruction;

public class CILStoreInstruction
implements IStoreInstruction {
    private final int index;
    private final Translator.RuntimeType type;
    private final boolean isArgument;

    CILStoreInstruction(int index, Translator.RuntimeType type, boolean isArgument) {
        this.index = index;
        this.type = type;
        this.isArgument = isArgument;
    }

    public String toString() {
        return "Store(" + (this.isArgument ? "arg" : "local") + "," + this.index + ")";
    }

    public String getType() {
        return this.type.toString();
    }

    public int getVarIndex() {
        return this.index;
    }

    public boolean isArgument() {
        return this.isArgument;
    }

    public int[] getBranchTargets() {
        return Instruction.noInstructions;
    }

    public int getPoppedCount() {
        return this.type.size();
    }

    public String getPushedType(String[] poppedTypesToCheck) {
        return null;
    }

    public byte getPushedWordSize() {
        return -1;
    }

    public boolean isFallThrough() {
        return true;
    }

    public boolean isPEI() {
        return false;
    }

    public IInstruction redirectTargets(int[] targetMap) {
        return this;
    }

    public void visit(IInstruction.Visitor v) {
        v.visitLocalStore((IStoreInstruction)this);
    }
}

