/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dotnet.cil;

import com.ibm.wala.dotnet.cil.Translator;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrikeBT.Instruction;

public class CILUnaryOpInstruction
implements IUnaryOpInstruction {
    private final IUnaryOpInstruction.IOperator op;
    private final Translator.RuntimeType type;

    CILUnaryOpInstruction(IUnaryOpInstruction.IOperator op, Translator.RuntimeType type) {
        this.op = op;
        this.type = type;
    }

    public String toString() {
        return "Unary(" + this.op + "," + (Object)((Object)this.type) + ")";
    }

    public IUnaryOpInstruction.IOperator getOperator() {
        return this.op;
    }

    public String getType() {
        return this.type.toString();
    }

    public int[] getBranchTargets() {
        return Instruction.noInstructions;
    }

    public int getPoppedCount() {
        return 1;
    }

    public String getPushedType(String[] poppedTypesToCheck) {
        return this.type.toString();
    }

    public byte getPushedWordSize() {
        return this.type.size();
    }

    public boolean isFallThrough() {
        return true;
    }

    public boolean isPEI() {
        return this.op == Operator.BOX || this.op == Operator.CPOBJ || this.op == Operator.CK_FINITE || this.op == Operator.UNBOX;
    }

    public IInstruction redirectTargets(int[] targetMap) {
        return this;
    }

    public void visit(IInstruction.Visitor v) {
        v.visitUnaryOp((IUnaryOpInstruction)this);
    }

    public static enum Operator implements IUnaryOpInstruction.IOperator
    {
        NOT,
        CK_FINITE,
        BOX,
        UNBOX,
        CPOBJ;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

