/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dotnet.loader;

import com.ibm.wala.classLoader.ArrayClassLoader;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.dotnet.loader.AssemblyModule;
import com.ibm.wala.dotnet.loader.CLRAnalysisScope;
import com.ibm.wala.dotnet.loader.CLRClass;
import com.ibm.wala.dotnet.loader.CLRLanguage;
import com.ibm.wala.dotnet.loader.CLRMethod;
import com.ibm.wala.dotnet.types.CLRTypeReference;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.ArrayIterator;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.IteratorUtil;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.functions.Function;
import com.ibm.wala.util.strings.Atom;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class AssemblyClassLoader<C, F, M, A, T>
implements IClassLoader {
    private final AssemblyModule<C, F, M, A, T> assembly;
    private final ClassLoaderReference ref;
    public final CLRAnalysisScope<C, F, M, A, T> scope;
    protected final Map<C, CLRClass<C, F, M, A, T>> table = new HashMap<C, CLRClass<C, F, M, A, T>>();
    private final IClassHierarchy cha;
    private final ArrayClassLoader arrayLoader = new ArrayClassLoader();
    private Set<IClass> removed = null;

    public AssemblyClassLoader(ClassLoaderReference ref, CLRAnalysisScope<C, F, M, A, T> scope, AssemblyModule<C, F, M, A, T> assembly, IClassHierarchy cha) {
        this.assembly = assembly;
        this.cha = cha;
        this.ref = ref;
        this.scope = scope;
    }

    public AssemblyModule<C, F, M, A, T> getAssembly() {
        return this.assembly;
    }

    private TypeReference makeTypeVarRef(C typeHandle) {
        return TypeReference.findOrCreate((ClassLoaderReference)CLRTypeReference.systemLoader, (TypeName)TypeName.findOrCreate((String)("Lvar/" + this.assembly.reader.classHandleToString(typeHandle))));
    }

    private TypeReference makeRefRef(C typeHandle) {
        return TypeReference.findOrCreateReferenceTo((TypeReference)this.getReference(this.assembly.reader.refGetReferrent(typeHandle)));
    }

    private TypeReference makePointerRef(C typeHandle) {
        return TypeReference.findOrCreatePointerTo((TypeReference)this.getReference(this.assembly.reader.pointerGetReferrent(typeHandle)));
    }

    private TypeReference makeWithRef(C typeHandle) {
        TypeReference withRef = TypeReference.findOrCreate((ClassLoaderReference)this.getReference(), (TypeName)TypeName.findOrCreate((String)("Lwith/" + this.assembly.reader.classHandleToString(typeHandle))));
        IClass withCls = this.ensureClass(withRef, typeHandle);
        assert (withCls != null);
        if (this.cha.lookupClass(withRef) == null) {
            this.cha.addClass(withCls);
        }
        return withRef;
    }

    public TypeReference getReference(C classHandle) {
        Object image = this.assembly.reader.classGetImage(classHandle);
        if (image.equals(this.assembly.getHandle())) {
            if (this.assembly.reader.classIsPrimitive(classHandle)) {
                return TypeReference.findOrCreate((ClassLoaderReference)CLRTypeReference.systemLoader, (String)("P" + this.assembly.reader.primitiveGetName(classHandle)));
            }
            if (this.assembly.reader.classIsArray(classHandle)) {
                Object element = this.assembly.reader.arrayGetElement(classHandle);
                return this.getReference(element).getArrayTypeForElementType();
            }
            if (this.assembly.reader.classIsReference(classHandle)) {
                return this.makeRefRef(classHandle);
            }
            if (this.assembly.reader.classIsPointer(classHandle)) {
                return this.makePointerRef(classHandle);
            }
            if (this.assembly.reader.classIsTypeVar(classHandle)) {
                return this.makeTypeVarRef(classHandle);
            }
            if (this.assembly.reader.classIsWith(classHandle)) {
                return this.makeWithRef(classHandle);
            }
            return TypeReference.findOrCreate((ClassLoaderReference)this.getReference(), (TypeName)TypeName.findOrCreate((String)("L" + this.assembly.reader.classGetName(classHandle))));
        }
        TypeReference ref = this.scope.findClass(classHandle);
        assert (ref != null) : this.assembly.reader.imageGetAssemblyName(this.assembly.reader.classGetImage(classHandle)) + ":" + this.assembly.reader.classGetName(classHandle);
        return ref;
    }

    public String toString() {
        return "Assembly:" + super.toString();
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    public Language getLanguage() {
        return CLRLanguage.lang;
    }

    public Atom getName() {
        return this.ref.getName();
    }

    public int getNumberOfClasses() {
        return IteratorUtil.count(this.iterateAllClasses());
    }

    public int getNumberOfMethods() {
        int methods = 0;
        Iterator<IClass> clss = this.iterateAllClasses();
        while (clss.hasNext()) {
            methods += clss.next().getDeclaredMethods().size();
        }
        return methods;
    }

    public IClassLoader getParent() {
        IClassLoader x = this.cha.getLoader(CLRTypeReference.systemLoader);
        if (x == this) {
            return null;
        }
        return x;
    }

    public ClassLoaderReference getReference() {
        return this.ref;
    }

    public void init(List<Module> modules) throws IOException {
        assert (modules.isEmpty());
    }

    public void removeAll(Collection<IClass> toRemove) {
        if (!toRemove.isEmpty()) {
            this.removed = new HashSet<IClass>(toRemove);
        }
    }

    IClass ensureClass(TypeReference ref, C handle) {
        IClass result = (IClass)this.table.get(handle);
        if (result == null) {
            return this.scope.ensureClass(this, ref, handle);
        }
        return result;
    }

    public C resolveTypeToken(CLRMethod<C, F, M, A, T> method, int token) {
        return this.assembly.reader.resolveTypeToken(method.handle, token);
    }

    public Descriptor computeMethodDescriptor(C declarerHandle, M methodHandle) {
        TypeName[] params = new TypeName[this.assembly.reader.methodGetNumberOfParameters(methodHandle)];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.getReference(this.assembly.reader.methodGetParameterType(methodHandle, i)).getName();
        }
        TypeName ret = this.getReference(this.assembly.reader.methodGetReturnType(methodHandle)).getName();
        return Descriptor.findOrCreate((TypeName[])params, (TypeName)ret);
    }

    public M resolveMethodToken(CLRMethod<C, F, M, A, T> method, int token) {
        return this.assembly.reader.resolveMethodToken(method.handle, token);
    }

    public String resolveStringToken(CLRMethod<C, F, M, A, T> method, int token) {
        return this.assembly.reader.resolveStringToken(method.handle, token);
    }

    public F resolveFieldToken(CLRMethod<C, F, M, A, T> method, int token) {
        return this.assembly.reader.resolveFieldToken(method.handle, token);
    }

    public Iterator<IClass> iterateAllClasses() {
        return new MapIterator((Iterator)new FilterIterator((Iterator)new ArrayIterator((Object[])this.assembly.getAllClasses()), new Predicate<C>(){

            public boolean test(C o) {
                return !AssemblyClassLoader.this.assembly.isExcluded(o) && (AssemblyClassLoader.this.removed == null || !AssemblyClassLoader.this.removed.contains(o));
            }
        }), new Function<C, IClass>(){

            public IClass apply(C object) {
                return AssemblyClassLoader.this.ensureClass(AssemblyClassLoader.this.getReference(object), object);
            }
        });
    }

    public IClass lookupClass(TypeName className) {
        C handle;
        if (className.isArrayType()) {
            return this.arrayLoader.lookupClass(className, (IClassLoader)this, this.cha);
        }
        String name = className.getClassName().toString();
        String pkg = null;
        if (className.getPackage() != null) {
            pkg = className.getPackage().toString();
        }
        if (!this.assembly.reader.classNotValid(handle = this.assembly.getClass(name, pkg))) {
            return this.ensureClass(this.getReference(handle), handle);
        }
        return null;
    }

    public SSAInstructionFactory getInstructionFactory() {
        return this.getLanguage().instructionFactory();
    }

    @Deprecated
    public String getSourceFileName(IClass klass) throws NoSuchElementException {
        TypeName tn = klass.getName();
        Collection<String> sourceFiles = this.assembly.getClassSourceFiles(tn.getClassName().toString(), tn.getPackage() == null ? null : tn.getPackage().toString());
        if (sourceFiles.size() == 1) {
            return sourceFiles.iterator().next();
        }
        if (sourceFiles.size() == 2) {
            String ret = null;
            for (String s : sourceFiles) {
                File relative = null;
                try {
                    relative = Paths.get(this.getAssembly().getAbsolutePath(), new String[0]).relativize(Paths.get(s, new String[0])).toFile();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (relative != null && relative.isAbsolute()) continue;
                ret = s;
            }
            return ret;
        }
        throw new NoSuchElementException("multiple source files for " + klass);
    }

    @Deprecated
    public Reader getSource(IClass klass) throws NoSuchElementException {
        try {
            return new FileReader(this.getSourceFileName(klass));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public Reader getSource(IMethod method, int offset) {
        try {
            return new FileReader(this.getSourceFileName(method, offset));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public String getSourceFileName(IMethod method, int bcIndex) {
        return this.assembly.reader.methodGetSourceFileName(((CLRMethod)method).handle, bcIndex);
    }

    Annotation[] instantiateAttributes(T[] attrDescs) {
        if (attrDescs == null) {
            return null;
        }
        Annotation[] attrs = new Annotation[attrDescs.length];
        for (int i = 0; i < attrDescs.length; ++i) {
            Object c = this.assembly.reader.attributeGetType(attrDescs[i]);
            TypeReference tr = TypeReference.findOrCreate((ClassLoaderReference)this.getReference(), (String)("L" + this.assembly.reader.classGetName(c)));
            int attributeArgumentCount = -1;
            try {
                attributeArgumentCount = this.assembly.reader.attributeArgumentCount(attrDescs[i]);
                Pair[] arguments = new Pair[attributeArgumentCount];
                for (int j = 0; j < arguments.length; ++j) {
                    TypeReference at = TypeReference.findOrCreate((ClassLoaderReference)this.getReference(), (String)("L" + this.assembly.reader.classGetName(this.assembly.reader.attributeArgumentType(attrDescs[i], j))));
                    arguments[j] = Pair.make((Object)at, (Object)this.assembly.reader.attributeArgumentValue(attrDescs[i], j));
                }
                attributeArgumentCount = this.assembly.reader.attributeNamedArgumentCount(attrDescs[i]);
                HashMap namedArguments = HashMapFactory.make();
                for (int j = 0; j < attributeArgumentCount; ++j) {
                    namedArguments.put(this.assembly.reader.attributeNamedArgumentName(attrDescs[i], j), new AnnotationsReader.ConstantElementValue((Object)this.assembly.reader.attributeNamedArgumentValue(attrDescs[i], j)));
                }
                attrs[i] = Annotation.makeUnnamedAndNamed((TypeReference)tr, (Map)namedArguments, (Pair[])arguments);
                continue;
            }
            catch (IllegalArgumentException e) {
                System.err.println("WARNING: couldn't read attribute argument count for annotation type " + tr);
                System.err.println("skipping arguments");
                attrs[i] = Annotation.makeWithUnnamed((TypeReference)tr, (Pair[])new Pair[0]);
            }
        }
        return attrs;
    }
}

